#include <cstdint>
#include "rexp.h"

/************************************************************
 * Tables for exponential                                   *
 ************************************************************/

const double ew[256] = {
	1.2069675079011484e-16, 8.8612678049440503e-19, 1.4549265620863870e-18, 1.9054893904415065e-18,
	2.2916061071546676e-18, 2.6362063868305971e-18, 2.9514100973039131e-18, 3.2444947153886082e-18,
	3.5202169427471812e-18, 3.7818801629017194e-18, 4.0318853185454606e-18, 4.2720404252312761e-18,
	4.5037462234180594e-18, 4.7281134710870544e-18, 4.9460402476219354e-18, 5.1582647227199269e-18,
	5.3654022605531501e-18, 5.5679721791029581e-18, 5.7664174768539770e-18, 5.9611196565807888e-18,
	6.1524100546599482e-18, 6.3405786306289291e-18, 6.5258808784908366e-18, 6.7085433271477371e-18,
	6.8887679660438645e-18, 7.0667358415495793e-18, 7.2426100060659536e-18, 7.4165379565111742e-18,
	7.5886536660589683e-18, 7.7590792889539857e-18, 7.9279266003788395e-18, 8.0952982199451699e-18,
	8.2612886572117488e-18, 8.4259852098408951e-18, 8.5894687389797594e-18, 8.7518143417549059e-18,
	8.9130919370757981e-18, 9.0733667780183043e-18, 9.2326999017272338e-18, 9.3911485259046524e-18,
	9.5487663994385245e-18, 9.7056041134973040e-18, 9.8617093784122320e-18, 1.0017127270844313e-17,
	1.0171900455052197e-17, 1.0326069381512542e-17, 1.0479672465673918e-17, 1.0632746249231648e-17,
	1.0785325545980135e-17, 1.0937443574020224e-17, 1.1089132075862811e-17, 1.1240421427769192e-17,
	1.1391340739497380e-17, 1.1541917945477229e-17, 1.1692179888311405e-17, 1.1842152395391181e-17,
	1.1991860349322490e-17, 1.2141327752776895e-17, 1.2290577788311883e-17, 1.2439632873643834e-17,
	1.2588514712803680e-17, 1.2737244343558670e-17, 1.2885842181442768e-17, 1.3034328060702351e-17,
	1.3182721272432199e-17, 1.3331040600148931e-17, 1.3479304353024355e-17, 1.3627530396979379e-17,
	1.3775736183819725e-17, 1.3923938778577466e-17, 1.4072154885207087e-17, 1.4220400870771050e-17,
	1.4368692788237607e-17, 1.4517046398002720e-17, 1.4665477188238066e-17, 1.4814000394158365e-17,
	1.4962631016293308e-17, 1.5111383837842316e-17, 1.5260273441183824e-17, 1.5409314223605190e-17,
	1.5558520412313907e-17, 1.5707906078786231e-17, 1.5857485152504972e-17, 1.6007271434134370e-17,
	1.6157278608176494e-17, 1.6307520255150364e-17, 1.6458009863332157e-17, 1.6608760840092264e-17,
	1.6759786522862493e-17, 1.6911100189764693e-17, 1.7062715069929972e-17, 1.7214644353536012e-17,
	1.7366901201588296e-17, 1.7519498755469641e-17, 1.7672450146281062e-17, 1.7825768503995815e-17,
	1.7979466966447377e-17, 1.8133558688171096e-17, 1.8288056849118447e-17, 1.8442974663261892e-17,
	1.8598325387107820e-17, 1.8754122328134209e-17, 1.8910378853169240e-17, 1.9067108396726569e-17,
	1.9224324469312459e-17, 1.9382040665719714e-17, 1.9540270673322969e-17, 1.9699028280389702e-17,
	1.9858327384421052e-17, 2.0018182000536459e-17, 2.0178606269915983e-17, 2.0339614468314131e-17,
	2.0501221014658977e-17, 2.0663440479750464e-17, 2.0826287595071779e-17, 2.0989777261727864e-17,
	2.1153924559525285e-17, 2.1318744756207879e-17, 2.1484253316862902e-17, 2.1650465913512611e-17,
	2.1817398434906681e-17, 2.1985066996531148e-17, 2.2153487950850087e-17, 2.2322677897796664e-17,
	2.2492653695530806e-17, 2.2663432471481279e-17, 2.2835031633690663e-17, 2.3007468882482357e-17,
	2.3180762222469628e-17, 2.3354929974927418e-17, 2.3529990790548660e-17, 2.3705963662607718e-17,
	2.3882867940554716e-17, 2.4060723344065557e-17, 2.4239549977573752e-17, 2.4419368345311373e-17,
	2.4600199366887980e-17, 2.4782064393437750e-17, 2.4964985224366788e-17, 2.5148984124734193e-17,
	2.5334083843302491e-17, 2.5520307631294872e-17, 2.5707679261898983e-17, 2.5896223050559222e-17,
	2.6085963876102003e-17, 2.6276927202741166e-17, 2.6469139103013458e-17, 2.6662626281697248e-17,
	2.6857416100770801e-17, 2.7053536605470071e-17, 2.7251016551509810e-17, 2.7449885433535893e-17,
	2.7650173514881209e-17, 2.7851911858702269e-17, 2.8055132360578864e-17, 2.8259867782664678e-17,
	2.8466151789482769e-17, 2.8674018985466398e-17, 2.8883504954352679e-17, 2.9094646300544195e-17,
	2.9307480692561986e-17, 2.9522046908722187e-17, 2.9738384885178471e-17, 2.9956535766482806e-17,
	3.0176541958828672e-17, 3.0398447186153206e-17, 3.0622296549288390e-17, 3.0848136588366122e-17,
	3.1076015348698159e-17, 3.1305982450369469e-17, 3.1538089161802719e-17, 3.1772388477572659e-17,
	3.2008935200772141e-17, 3.2247786030256642e-17, 3.2488999653121836e-17, 3.2732636842799059e-17,
	3.2978760563186785e-17, 3.3227436079273064e-17, 3.3478731074744071e-17, 3.3732715777118618e-17,
	3.3989463090997737e-17, 3.4249048740072691e-17, 3.4511551418595214e-17, 3.4777052953080451e-17,
	3.5045638475087293e-17, 3.5317396606003165e-17, 3.5592419654852176e-17, 3.5870803830247721e-17,
	3.6152649467724945e-17, 3.6438061273816171e-17, 3.6727148588375358e-17, 3.7020025666818321e-17,
	3.7316811984125566e-17, 3.7617632562657727e-17, 3.7922618326062537e-17, 3.8231906481810755e-17,
	3.8545640935191375e-17, 3.8863972737928329e-17, 3.9187060574958295e-17, 3.9515071293338828e-17,
	3.9848180477746420e-17, 4.0186573077584973e-17, 4.0530444091368152e-17, 4.0879999314778012e-17,
	4.1235456159653546e-17, 4.1597044552145899e-17, 4.1965007919415557e-17, 4.2339604275568815e-17,
	4.2721107419070462e-17, 4.3109808255667805e-17, 4.3506016262968029e-17, 4.3910061115287249e-17,
	4.4322294490309904e-17, 4.4743092082553463e-17, 4.5172855852738264e-17, 4.5612016547056788e-17,
	4.6061036526195267e-17, 4.6520412951002597e-17, 4.6990681380203207e-17, 4.7472419845860936e-17,
	4.7966253484865177e-17, 4.8472859820098697e-17, 4.8992974803892867e-17, 4.9527399759834694e-17,
	5.0077009388206777e-17, 5.0642761036957171e-17, 5.1225705486288288e-17, 5.1826999553636313e-17,
	5.2447920900917493e-17, 5.3089885522804819e-17, 5.3754468520843384e-17, 5.4443428933674400e-17,
	5.5158739612950880e-17, 5.5902623428249154e-17, 5.6677597482072931e-17, 5.7486527561324156e-17,
	5.8332695808893447e-17, 5.9219885665781150e-17, 6.0152489660365474e-17, 6.1135647842402624e-17,
	6.2175427952399247e-17, 6.3279063401801996e-17, 6.4455272860976037e-17, 6.5714697525278435e-17,
	6.7070512213900258e-17, 6.8539300428233787e-17, 7.0142343183439483e-17, 7.1907581018791634e-17,
	7.3872720520651263e-17, 7.6090392702261334e-17, 7.8637237935969451e-17, 8.1631150669550498e-17,
	8.5267413487861608e-17, 8.9905562076117020e-17, 9.6326191875401209e-17, 1.0681896298230034e-16
};

const double ef[256] = {
	1.0000000000000000e+00, 9.3814368086217614e-01, 9.0046992992574748e-01, 8.7170433238120448e-01,
	8.4778550062399038e-01, 8.2699329664305099e-01, 8.0842165152300893e-01, 7.9152763697249617e-01,
	7.7595685204011611e-01, 7.6146338884989673e-01, 7.4786862198519555e-01, 7.3503809243142393e-01,
	7.2286765959357235e-01, 7.1127476080507634e-01, 7.0019265508278850e-01, 6.8956649611707832e-01,
	6.7935057226476570e-01, 6.6950631673192507e-01, 6.6000084107900003e-01, 6.5080583341457132e-01,
	6.4189671642726631e-01, 6.3325199421436629e-01, 6.2485273870366609e-01, 6.1668218091520777e-01,
	6.0872538207962223e-01, 6.0096896636523245e-01, 5.9340090169173365e-01, 5.8601031847726825e-01,
	5.7878735860284525e-01, 5.7172304866482604e-01, 5.6480919291240050e-01, 5.5803828226258778e-01,
	5.5140341654064162e-01, 5.4489823767243994e-01, 5.3851687200286213e-01, 5.3225388026304354e-01,
	5.2610421398361995e-01, 5.2006317736823382e-01, 5.1412639381474878e-01, 5.0828977641064310e-01,
	5.0254950184134795e-01, 4.9690198724154977e-01, 4.9134386959403276e-01, 4.8587198734188514e-01,
	4.8048336393045443e-01, 4.7517519303737760e-01, 4.6994482528396020e-01, 4.6478975625042640e-01,
	4.5970761564213786e-01, 4.5469615747461567e-01, 4.4975325116275516e-01, 4.4487687341454868e-01,
	4.4006510084235406e-01, 4.3531610321563680e-01, 4.3062813728845906e-01, 4.2599954114303457e-01,
	4.2142872899761680e-01, 4.1691418643300310e-01, 4.1245446599716135e-01, 4.0804818315203256e-01,
	4.0369401253053044e-01, 3.9939068447523124e-01, 3.9513698183329032e-01, 3.9093173698479727e-01,
	3.8677382908413782e-01, 3.8266218149600995e-01, 3.7859575940958090e-01, 3.7457356761590221e-01,
	3.7059464843514606e-01, 3.6665807978151421e-01, 3.6276297335481789e-01, 3.5890847294874995e-01,
	3.5509375286678768e-01, 3.5131801643748356e-01, 3.4758049462163715e-01, 3.4388044470450252e-01,
	3.4021714906678019e-01, 3.3658991402867766e-01, 3.3299806876180904e-01, 3.2944096426413633e-01,
	3.2591797239355619e-01, 3.2242848495608911e-01, 3.1897191284495718e-01, 3.1554768522712889e-01,
	3.1215524877417955e-01, 3.0879406693456013e-01, 3.0546361924459020e-01, 3.0216340067569347e-01,
	2.9889292101558174e-01, 2.9565170428126120e-01, 2.9243928816189257e-01, 2.8925522348967775e-01,
	2.8609907373707688e-01, 2.8297041453878080e-01, 2.7986883323697292e-01, 2.7679392844851736e-01,
	2.7374530965280297e-01, 2.7072259679906002e-01, 2.6772541993204479e-01, 2.6475341883506226e-01,
	2.6180624268936303e-01, 2.5888354974901628e-01, 2.5598500703041543e-01, 2.5311029001562951e-01,
	2.5025908236886235e-01, 2.4743107566532765e-01, 2.4462596913189213e-01, 2.4184346939887724e-01,
	2.3908329026244915e-01, 2.3634515245705962e-01, 2.3362878343743335e-01, 2.3093391716962741e-01,
	2.2826029393071667e-01, 2.2560766011668401e-01, 2.2297576805812014e-01, 2.2036437584335944e-01,
	2.1777324714870044e-01, 2.1520215107537860e-01, 2.1265086199297820e-01, 2.1011915938898817e-01,
	2.0760682772422195e-01, 2.0511365629383763e-01, 2.0263943909370891e-01, 2.0018397469191118e-01,
	1.9774706610509873e-01, 1.9532852067956311e-01, 1.9292814997677121e-01, 1.9054576966319528e-01,
	1.8818119940425418e-01, 1.8583426276219700e-01, 1.8350478709776735e-01, 1.8119260347549618e-01,
	1.7889754657247819e-01, 1.7661945459049477e-01, 1.7435816917135338e-01, 1.7211353531531992e-01,
	1.6988540130252752e-01, 1.6767361861725005e-01, 1.6547804187493587e-01, 1.6329852875190168e-01,
	1.6113493991759190e-01, 1.5898713896931407e-01, 1.5685499236936512e-01, 1.5473836938446797e-01,
	1.5263714202744280e-01, 1.5055118500103984e-01, 1.4848037564386671e-01, 1.4642459387834483e-01,
	1.4438372216063466e-01, 1.4235764543247209e-01, 1.4034625107486234e-01, 1.3834942886358012e-01,
	1.3636707092642877e-01, 1.3439907170221355e-01, 1.3244532790138744e-01, 1.3050573846833072e-01,
	1.2858020454522814e-01, 1.2666862943751062e-01, 1.2477091858083088e-01, 1.2288697950954505e-01,
	1.2101672182667474e-01, 1.1916005717532760e-01, 1.1731689921155547e-01, 1.1548716357863345e-01,
	1.1367076788274424e-01, 1.1186763167005624e-01, 1.1007767640518532e-01, 1.0830082545103370e-01,
	1.0653700405000158e-01, 1.0478613930657010e-01, 1.0304816017125766e-01, 1.0132299742595359e-01,
	9.9610583670637090e-02, 9.7910853311492158e-02, 9.6223742550432784e-02, 9.4549189376055831e-02,
	9.2887133556043527e-02, 9.1237516631040155e-02, 8.9600281910032845e-02, 8.7975374467270204e-02,
	8.6362741140756885e-02, 8.4762330532368105e-02, 8.3174093009632355e-02, 8.1597980709237419e-02,
	8.0033947542319905e-02, 7.8481949201606435e-02, 7.6941943170480517e-02, 7.5413888734058410e-02,
	7.3897746992364746e-02, 7.2393480875708724e-02, 7.0901055162371815e-02, 6.9420436498728755e-02,
	6.7951593421936615e-02, 6.6494496385339788e-02, 6.5049117786753763e-02, 6.3615431999807348e-02,
	6.2193415408541008e-02, 6.0783046445479633e-02, 5.9384305633420252e-02, 5.7997175631200631e-02,
	5.6621641283742842e-02, 5.5257689676697003e-02, 5.3905310196046052e-02, 5.2564494593071664e-02,
	5.1235237055126254e-02, 4.9917534282706358e-02, 4.8611385573379476e-02, 4.7316792913181541e-02,
	4.6033761076175156e-02, 4.4762297732943268e-02, 4.3502413568888176e-02, 4.2254122413316220e-02,
	4.1017441380414806e-02, 3.9792391023374105e-02, 3.8578995503074837e-02, 3.7377282772959347e-02,
	3.6187284781931409e-02, 3.5009037697397404e-02, 3.3842582150874323e-02, 3.2687963508959528e-02,
	3.1545232172893595e-02, 3.0414443910466597e-02, 2.9295660224637383e-02, 2.8188948763978622e-02,
	2.7094383780955789e-02, 2.6012046645134207e-02, 2.4942026419731776e-02, 2.3884420511558164e-02,
	2.2839335406385230e-02, 2.1806887504283574e-02, 2.0787204072578114e-02, 1.9780424338009740e-02,
	1.8786700744696024e-02, 1.7806200410911355e-02, 1.6839106826039941e-02, 1.5885621839973156e-02,
	1.4945968011691148e-02, 1.4020391403181943e-02, 1.3109164931254991e-02, 1.2212592426255378e-02,
	1.1331013597834600e-02, 1.0464810181029981e-02, 9.6144136425022134e-03, 8.7803149858089770e-03,
	7.9630774380170435e-03, 7.1633531836349908e-03, 6.3819059373191834e-03, 5.6196422072054882e-03,
	4.8776559835424001e-03, 4.1572951208338005e-03, 3.4602647778369071e-03, 2.7887987935740783e-03,
	2.1459677437189071e-03, 1.5362997803015726e-03, 9.6726928232717432e-04, 4.5413435384149660e-04
};

#define N INT64_C
const int64_t ek[256] = {
	N(0xE290A13924BE28), N(0x00000000000000), N(0x9BEADEBCE189B0), N(0xC377AC71F9DFA8),
	N(0xD4DDB990758510), N(0xDE893FB8CA2398), N(0xE4A8E87C4328A0), N(0xE8DFF16AE1CB80),
	N(0xEBF2DEAB58C588), N(0xEE49A6E8B96378), N(0xF0204EFD64EE40), N(0xF19BDB8EA3C1A8),
	N(0xF2D458BBE5BD00), N(0xF3DA104B782368), N(0xF4B86D784571E0), N(0xF577AD8A7784F0),
	N(0xF61DE83DA32AC0), N(0xF6AFB7843CCE68), N(0xF730A57372B440), N(0xF7A37651B0E680),
	N(0xF80A5BB6EEA518), N(0xF867189D3CB5A8), N(0xF8BB1B4F8FBBC8), N(0xF9079062292B90),
	N(0xF94D70CA8D43B0), N(0xF98D8C7DCAA998), N(0xF9C8928ABE0838), N(0xF9FF175B734A60),
	N(0xFA319996BC47E8), N(0xFA6085F8E9D078), N(0xFA8C3A62E19918), N(0xFAB5084E1F6608),
	N(0xFADB36C84CCCB8), N(0xFAFF0410868460), N(0xFB20A6EA22BB80), N(0xFB404FB42CB3D0),
	N(0xFB5E2951581738), N(0xFB7A59E99727A8), N(0xFB95038C8789C8), N(0xFBAE44BA684ED0),
	N(0xFBC638D822E600), N(0xFBDCF89209FFA8), N(0xFBF29A303CFC50), N(0xFC0731DF1089C0),
	N(0xFC1AD1ED6C8B18), N(0xFC2D8B02B5C898), N(0xFC3F6C4D921318), N(0xFC5083AC9BA7D8),
	N(0xFC60DDD1E9CD68), N(0xFC7086622E8250), N(0xFC7F881009F0B8), N(0xFC8DECB41AC708),
	N(0xFC9BBD623D7ED0), N(0xFCA9027C5B26D8), N(0xFCB5C3C319C498), N(0xFCC20864B44490),
	N(0xFCCDD70A35D408), N(0xFCD935E34BF800), N(0xFCE42AB0DB8BD0), N(0xFCEEBACE7EC020),
	N(0xFCF8EB3B0D0E78), N(0xFD02C0A049B608), N(0xFD0C3F59D199D0), N(0xFD156B7B5E27E8),
	N(0xFD1E48D6703418), N(0xFD26DAFF735510), N(0xFD2F2552684BE8), N(0xFD372AF7233C18),
	N(0xFD3EEEE528F628), N(0xFD4673E73543B0), N(0xFD4DBC9E72FF88), N(0xFD54CB856DC2D0),
	N(0xFD5BA2F2C41198), N(0xFD62451BA02C28), N(0xFD68B415FCFF48), N(0xFD6EF1DABC1600),
	N(0xFD75004790EB70), N(0xFD7AE120C583E8), N(0xFD809612DBD098), N(0xFD8620B40EFF98),
	N(0xFD8B8285B78FE0), N(0xFD90BCF594B1D8), N(0xFD95D15EFD4258), N(0xFD9AC10BFA70C8),
	N(0xFD9F8D364DF068), N(0xFDA437086566B8), N(0xFDA8BF9E3C9FF0), N(0xFDAD28062FED50),
	N(0xFDB17141BFF2D0), N(0xFDB59C46480858), N(0xFDB9A9FDA83CD0), N(0xFDBD9B46E3ED48),
	N(0xFDC170F6B5D050), N(0xFDC52BD81A3FB0), N(0xFDC8CCACD07BA0), N(0xFDCC542DD39020),
	N(0xFDCFC30BCB7930), N(0xFDD319EF771438), N(0xFDD6597A0F60B8), N(0xFDD98245A48A30),
	N(0xFDDC94E5752720), N(0xFDDF91E64014E8), N(0xFDE279CE914CB0), N(0xFDE54D1F0A06A8),
	N(0xFDE80C52A47D00), N(0xFDEAB7DEF394E0), N(0xFDED50345EB360), N(0xFDEFD5BE59FA10),
	N(0xFDF248E39B26F0), N(0xFDF4AA064B4B00), N(0xFDF6F984358948), N(0xFDF937B6F30BA8),
	N(0xFDFB64F4145718), N(0xFDFD818D482620), N(0xFDFF8DD07FED88), N(0xFE018A08122C48),
	N(0xFE03767ADAA598), N(0xFE05536C58A140), N(0xFE07211CCB4C58), N(0xFE08DFC94C5328),
	N(0xFE0A8FABE8CA18), N(0xFE0C30FBB87A60), N(0xFE0DC3ECF3A5A0), N(0xFE0F48B1075218),
	N(0xFE10BF76A82EF0), N(0xFE122869E42000), N(0xFE1383B4327E10), N(0xFE14D17C831880),
	N(0xFE1611E74C0230), N(0xFE1745169635A8), N(0xFE186B2A091770), N(0xFE19843EF4E078),
	N(0xFE1A90705BF640), N(0xFE1B8FD6FB37C8), N(0xFE1C8289514438), N(0xFE1D689BA4BFD0),
	N(0xFE1E4220099A48), N(0xFE1F0F26655A00), N(0xFE1FCFBC726D40), N(0xFE2083EDC28310),
	N(0xFE212BC3BFEB40), N(0xFE21C745ADFE38), N(0xFE225678A88958), N(0xFE22D95FA23F48),
	N(0xFE234FFB622830), N(0xFE23BA4A800D90), N(0xFE2418495FDDC8), N(0xFE2469F22BFFB8),
	N(0xFE24AF3CCE90D8), N(0xFE24E81EE98588), N(0xFE25148BCDA1A0), N(0xFE253474703FE0),
	N(0xFE2547C75FDC68), N(0xFE254E70B754F8), N(0xFE25485A0FD1B0), N(0xFE25356A714508),
	N(0xFE2515864173B0), N(0xFE24E88F316F18), N(0xFE24AE64296FA0), N(0xFE2466E132F608),
	N(0xFE2411DF611BD0), N(0xFE23AF34B6F738), N(0xFE233EB40BF418), N(0xFE22C02CEE01C0),
	N(0xFE22336B817110), N(0xFE2198385E5CD0), N(0xFE20EE586B7070), N(0xFE20358CB5DFB8),
	N(0xFE1F6D92465B10), N(0xFE1E9621F2C9F0), N(0xFE1DAEF02C8DA8), N(0xFE1CB7ACCB0A68),
	N(0xFE1BB002D22CA0), N(0xFE1A9798349B90), N(0xFE196E0D9140D8), N(0xFE1832FDEBC440),
	N(0xFE16E5FE5F9320), N(0xFE15869DCCFD00), N(0xFE1414647FE780), N(0xFE128ED3CF8B20),
	N(0xFE10F565B69CF0), N(0xFE0F478C633AB8), N(0xFE0D84B1BDD9E8), N(0xFE0BAC36E66888),
	N(0xFE09BD73A6B5C0), N(0xFE07B7B5D920B0), N(0xFE059A40C26D20), N(0xFE03644C5D7F88),
	N(0xFE011504979B28), N(0xFDFEAB887B95C0), N(0xFDFC26E94A4480), N(0xFDF986297E3068),
	N(0xFDF6C83BB86630), N(0xFDF3EC0193EEE0), N(0xFDF0F04A5D30A8), N(0xFDEDD3D1AA2040),
	N(0xFDEA953DCFC130), N(0xFDE7331E3100D8), N(0xFDE3ABE9626F28), N(0xFDDFFDFB1DBD50),
	N(0xFDDC2791FF3510), N(0xFDD826CD068C70), N(0xFDD3F9A8D38568), N(0xFDCF9DFC95B0D0),
	N(0xFDCB1176A55FE0), N(0xFDC65198BA50C0), N(0xFDC15BB3B2DAA0), N(0xFDBC2CE2DC4AE8),
	N(0xFDB6C206AAACA0), N(0xFDB117BECB4A18), N(0xFDAB2A6379BF10), N(0xFDA4F5FDFB4E90),
	N(0xFD9E76401F3A38), N(0xFD97A67A9CE200), N(0xFD9081922142A0), N(0xFD8901F2D4B028),
	N(0xFD812182170E18), N(0xFD78D98E23CD38), N(0xFD7022BB3F0830), N(0xFD66F4EDF96B98),
	N(0xFD5D4732003058), N(0xFD530F9CCFF948), N(0xFD48432B7B3510), N(0xFD3CD59A8469E8),
	N(0xFD30B9368F90A8), N(0xFD23DEA45F5000), N(0xFD16349E2E04A8), N(0xFD07A7A3EF98B0),
	N(0xFCF8219B5DF058), N(0xFCE7895BCFCDE8), N(0xFCD5C220AD5E30), N(0xFCC2AADBC17DC8),
	N(0xFCAE1D5E81FBD0), N(0xFC97ED4E778F98), N(0xFC7FE6D4D720E8), N(0xFC65CCF39C2FC0),
	N(0xFC4957623CB040), N(0xFC2A2FC826DC80), N(0xFC07EE19B01CD8), N(0xFBE213C1CF4930),
	N(0xFBB8051AC15670), N(0xFB890078D120E8), N(0xFB5411A5B9A960), N(0xFB180005471338),
	N(0xFAD334827F1E30), N(0xFA839276708B98), N(0xFA263B32E37ED8), N(0xF9B72D1C52CD20),
	N(0xF930A1A281A058), N(0xF889F023D820A0), N(0xF7B577D2BE5F38), N(0xF69C650C40A8F0),
	N(0xF51530F0916D88), N(0xF2CB0E3C5933E8), N(0xEEEFB15D605D88), N(0xE6DA6ECF274600)
};
#undef N
