# inspired by https://github.com/SMAT-Lab/Scalpel/blob/d0df274dea179d022fe5305ce2c130a9d2c22ee1/scalpel/core/util.py
# #L145

import ast

class Unit:

    def __init__(self, parent, node):
        self.parent = parent
        self.node = node

    def insert_stmt_before(self, new_stmt):
        if self.parent is not None and hasattr(self.parent, "body"):
            try:
                pos = self.parent.body.index(self.node)
                self.parent.body.insert(pos, new_stmt)
            except Exception as e:
                raise "Insertion Failure"
        else:
            raise "Error!"

    def insert_stmts_before(self, new_stmts):
        if self.parent is not None and hasattr(self.parent, "body"):
            try:
                pos = self.parent.body.index(self.node)
                self.parent.body[pos:pos + 1] = new_stmts
            except Exception as e:
                raise "Insertion error"
        else:
            raise "Error!"


def extend_ast_tree(root_node):
    """
    Adding information about the parent of each node
    :param root_node: the root of the ast tree
    :return: generator of unit node
    """
    from collections import deque
    init_stmt = []

    for node in root_node.body:

        node.parent = root_node
        init_stmt += [node]

    queue = deque(init_stmt)
    while len(queue) > 0:
        node = queue.popleft()
        yield Unit(node.parent, node)
        if hasattr(node, "body"):
            for ch_node in node.body:
                ch_node.parent = node
                queue.append(ch_node)


