from rewriter import *
import time
import numpy as np
import argparse
from concurrent.futures import ProcessPoolExecutor
from concurrent.futures import ThreadPoolExecutor


# reference
# {'system': './dnspython.git',
# 'total_files': 201,
# 'number_of_files_with_for': 73,
# 'tot_for': 307,
# 'tot_for_transf': 27,
# 'tot_for_transf_test_ok': 21}

def get_number_passed_test(text):
    assert text is not None, "text must not be none"

    lines_text = text.split('\n')
    lines_text = list(filter(lambda x: len(x) > 0, lines_text))
    size = len(lines_text)
    last_line = lines_text[size - 1]
    print(last_line)
    last_line = last_line.replace("=", "")
    arr = last_line.split()

    for i in range(len(arr) - 1):
        if "passed" in arr[i + 1]:
            number = arr[i]
            return number

    return 0


class Stats(ast.NodeVisitor):

    def __init__(self, project):
        assert project is not None, "project must not be none"
        self.project = project
        self.output = "stats.txt"
        self.current_count = 0
        self.lines = list()

    def generate_stats(self):
        files = get_all_files(directory=self.project, extension=".py")
        fp = open(self.output, "a")

        for file in files:
            src = open_file(file_path=file)
            try:
                tree = ast.parse(src)
                self.visit(tree)
                if self.current_count > 0:
                    lines = ",".join([str(c) for c in self.lines])
                    line = ",".join([str(file), str(self.current_count), lines])
                    print(line, file=fp)
                    self.current_count = 0
                    self.lines = list()
            except Exception as error:
                print(error)

        fp.close()

    def visit_For(self, node: ast.For):
        self.current_count += 1
        self.lines.append((node.lineno, node.end_lineno))


def main():
    parser = argparse.ArgumentParser(
        description='Python AST parser')

    parser.add_argument("--p",
                        type=str,
                        nargs='?',
                        dest='project',
                        help="project to execute")

    args = (parser.parse_args())

    project = args.project
    assert project is not None, "project to process is missing"

    pytest = "pytest"
    cmd = " ".join([f'cd {project};', f'{pytest}'])
    reference = subprocess.run(cmd, shell=True, capture_output=True)
    number_test_passed = get_number_passed_test(text=reference.stdout.decode())
    print(number_test_passed)

    python_files = get_all_files(directory=project, extension=".py")

    info_system = {
        "system": project,
        "total_files": len(python_files),
        "number_of_files_with_for": 0,
        "tot_for": 0,
        "tot_for_transf": 0,
        "tot_for_transf_test_ok": 0
    }

    # parallelize this
    for file in python_files:
        print(f"going for file {file}")
        rewrite(info=info_system, file=file, rule_func=for_rewrite_rules, n=number_test_passed)

    row = list(info_system.values())

    write_row_in_csv(filename="overview.csv", row=row)
    write_in_json(filename="overview.json", row=info_system)


if __name__ == '__main__':
    main()
