""" rules database to convert code
    code by Ossim Belias
"""
import ast
from typing import Any
from process import *
from helper import print_node


# TODO try refactor here

def for_rewrite_rules(node, source: Source):
    conversion = list()
    rule = ""
    if isinstance(node, ast.For):
        body = process_body(node.body)
        print(body)
        if len(body) > 0:
            target, iter = node.target, node.iter
            for b_node in body:
                if istype(b_node, NodeExpr):
                    # F2L.1
                    elt = get_source(variable=b_node.args_expr[0],
                                     source=source,
                                     var_type=VariableType.ARGUMENT)

                    # TODO: remove here, here to just make code pass other cases instead of brutally stop
                    if elt is None:
                        continue

                    generator = [ast.comprehension(target, iter, [], 0)]
                    value = NodeListComp(elt, generator)

                    assignation_target: list[Any] = [b_node.func_expr.value]
                    assign_node = NodeAssign(targets=assignation_target, value=value)
                    node_assign = generate_astAssign(assign_node)
                    conversion.append(node_assign)
                    rule = "F2L.1"

                elif istype(b_node, NodeIf):
                    # F2L.2
                    node_expr = b_node.node_expr.pop(0)
                    elt = get_source(variable=node_expr.args_expr.pop(0),
                                     source=source,
                                     var_type=VariableType.ARGUMENT)

                    # TODO: remove here, here to just make code pass other cases instead of brutally stop
                    if elt is None:
                        continue

                    generator = [ast.comprehension(target, iter, [b_node.test], 0)]
                    value = NodeListComp(elt, generator)
                    assignation_target = [node_expr.func_expr.value]
                    assign_node = NodeAssign(targets=assignation_target, value=value)
                    node_assign = generate_astAssign(assign_node)
                    conversion.append(node_assign)
                    rule = "F2L.2"

                elif istype(b_node, NodeIFExp):
                    # F2L.3
                    elt = generate_astIfExpr(node=b_node, source=source)

                    # TODO: remove here, here to just make code pass other cases instead of brutally stop
                    if elt is None:
                        continue

                    generator = [ast.comprehension(target, iter, [], 0)]
                    value = NodeListComp(elt=elt, generators=generator)
                    node_expr = b_node.node_expr.pop(0)
                    assignation_target = [node_expr.func_expr.value]
                    assign_node: NodeAssign = NodeAssign(targets=assignation_target, value=value)
                    node_assign = generate_astAssign(node=assign_node)
                    conversion.append(node_assign)
                    rule = "F2L.3"

                elif istype(b_node, NodeFor):
                    # F2L.5
                    elt = b_node.target
                    generators = [ast.comprehension(target, iter, [], 0),
                                  ast.comprehension(b_node.target, b_node.iter, [], 0)]
                    value = NodeListComp(elt=elt, generators=generators)
                    node_expr = b_node.body.pop(0)
                    assignation_target = [node_expr.func_expr.value]
                    assign_node: NodeAssign = NodeAssign(targets=assignation_target, value=value)
                    node_assign = generate_astAssign(node=assign_node)
                    conversion.append(node_assign)
                    rule = "F2L.5"

    return conversion, rule


def list_comp_rewrite_rules(node, source: Source):
    conversion = []
    rules_used = list()
    if isinstance(node, ast.Assign):
        if isinstance(node.value, ast.ListComp):
            targets, elt, generators = node.targets, node.value.elt, node.value.generators
            target_body = targets.pop(0)
            func = ast.Attribute(value=target_body, attr="append")
            for_body = []

            heading = generators.pop(0)
            target_head, iter_head, ifs_head = heading.target, heading.iter, heading.ifs

            if len(ifs_head) > 0:
                node_if = NodeIf(test=ifs_head.pop(0), node_expr=[NodeExpr(func_expr=func, args_expr=elt)])
                ast_if = node_if.generate_astIf()
                for_body.append(ast_if)
            elif type(elt) == ast.IfExp:
                node_expr_if = NodeExpr(func_expr=func, args_expr=elt.body)
                node_expr_orelse = NodeExpr(func_expr=func, args_expr=elt.orelse)
                node_if = NodeIf(test=elt.test, node_expr=[node_expr_if], orelse=[node_expr_orelse])
                ast_if = node_if.generate_astIf()
                for_body.append(ast_if)
            else:

                if len(generators) > 0:
                    for comprehension in generators:
                        body = []
                        target, iter, ifs = comprehension.target, comprehension.iter, comprehension.ifs
                        if len(ifs) > 0:
                            node_if = NodeIf(test=ifs.pop(0), node_expr=[NodeExpr(func_expr=func, args_expr=elt)])
                            ast_if = node_if.generate_astIf()
                            body.append(ast_if)
                        else:
                            call = ast.Call(func=func, args=[elt], keywords=[])
                            body.append(ast.Expr(value=call, orlse=[]))

                        in_for = NodeFor(target=target, iter=iter, body=body)
                        for_body.append(in_for.generate_astFor())
                else:
                    call = ast.Call(func=func, args=[elt], keywords=[])
                    for_body.append(ast.Expr(value=call, orlse=[]))

            node_for = NodeFor(target=target_head, iter=iter_head, body=for_body)

            empty_lst = ast.List(elts=[])
            empty_assign = ast.Assign([target_body], empty_lst)
            ast_for = node_for.generate_astFor()

            conversion.append(empty_assign)
            conversion.append(ast_for)

    return conversion, rules_used
