"""
    Testing the timing performance between the for loop transformation and list comp transformation
"""

from testCases import *
from rewriter import *
import time
import helper
import timeit
from benchmark import BenchMark
from helper import time_distance, delete_file

MAX_INNER_LOOP = 10
MAX_OUTER_LOOP = 30


def run_performance(src, filename, perf_type):
    delete_file(filename=filename)
    header = ["original time", "transformed time"]
    helper.write_row_in_csv(filename=filename, row=header)
    counter = 0

    while counter != MAX_OUTER_LOOP:

        new_src = ""
        # transforming the code
        if perf_type == "for_loop":
            rewriter = Rewriter(src=src, rule_func=for_rewrite_rules)
            new_src, stmts = rewriter.rewrite()
        elif perf_type == "list_comp":
            rewriter = Rewriter(src=src, rule_func=list_comp_rewrite_rules)
            new_src, stmts = rewriter.rewrite()
        else:
            raise "performance type is not recognized make sure to choose between for_loop and list_comp"

        # measuring the performance of the code
        elapsed_time_o = timeit.timeit(stmt=src, number=MAX_INNER_LOOP)
        elapsed_time_t = timeit.timeit(stmt=new_src, number=MAX_INNER_LOOP)

        # writing the results
        row = [str(elapsed_time_o), str(elapsed_time_t)]
        helper.write_row_in_csv(filename=filename, row=row)

        # incrementing the count
        counter += 1


def calculate_effect_size(filename):
    from cliffs_delta import cliffs_delta
    f = open(filename, 'r')
    next(f)

    first_column = []
    second_column = []

    for line in f:
        line = line.replace("\n", "")
        a, b = line.split(',')
        first_column.append(float(a))
        second_column.append(float(b))

    f.close()

    print(first_column)
    print(second_column)

    d, res = cliffs_delta(first_column, second_column)
    s = " ".join([str(d), str(res)])

    f = open(filename, "a")
    print(s, file=f)
    f.close()


def main():
    LIMIT = 4
    for i in range(1, LIMIT, 1):
        filename = "../performance/p{i}_{iteration}.txt".format(i=i, iteration=10000)
        src = open_file("./tests/code_for_{i}.py".format(i=i))
        run_performance(src=src, filename=filename, perf_type="for_loop")
        calculate_effect_size(filename=filename)

    for i in range(1, LIMIT, 1):
        filename = "../performance/list_p{i}_{iteration}.txt".format(i=i, iteration=10000)
        src = open_file("./tests/list_comp_{i}.py".format(i=i))
        run_performance(src=src, filename=filename, perf_type="list_comp")
        calculate_effect_size(filename=filename)


if __name__ == '__main__':
    main()
