""" All the node structure
    code by Ossim Belias
"""

from dataclasses import dataclass
import ast


@dataclass
class NodeFor:
    iter: None
    target: None
    body: None

    def __init__(self, iter, target, body):
        self.iter = iter
        self.target = target
        self.body = body

    def get_properties_node(self):
        return self.target, self.iter, self.body

    def generate_astFor(self):
        ast_for = ast.For(target=self.target,
                          iter=self.iter,
                          body=self.body,
                          orelse=[],
                          type_comment=None)

        return ast_for


@dataclass
class NodeExpr:
    func_expr: None
    args_expr: None

    def __init__(self, func_expr, args_expr):
        self.func_expr = func_expr
        self.args_expr = args_expr

    def generate_astExpr(self):
        call = ast.Call(func=self.func_expr, args=[self.args_expr], keywords=[])
        ast_expr = ast.Expr(value=call)

        return ast_expr


@dataclass
class NodeIf:
    test: ast.Call | ast.Compare | ast.BoolOp
    node_expr: list()
    orelse: list()

    def __init__(self, test, node_expr, orelse=[]):
        self.test = test
        self.node_expr = node_expr
        self.orelse = orelse

    def generate_astIf(self):
        ast_if = ast.If(test=self.test,
                        body=[expr.generate_astExpr() for expr in self.node_expr],
                        orelse=[expr.generate_astExpr() for expr in self.orelse])

        return ast_if


@dataclass
class NodeIFExp:
    test: ast.Call | ast.Compare | ast.BoolOp
    node_expr: list()
    orelse: ast.Call | ast.Compare | ast.BoolOp | ast.BinOp

    def __init__(self, test, node_expr, orelse):
        self.test = test
        self.node_expr = node_expr
        self.orelse = orelse


@dataclass
class NodeListComp:
    elt: None
    generators: list()

    def __init__(self, elt, generators):
        self.elt = elt
        self.generators = generators

    def get_properties_node(self):
        return self.elt, self.generators


@dataclass
class NodeAssign:
    targets: []
    value: NodeListComp

    def __init__(self, targets: object, value: object) -> object:
        self.targets = targets
        self.value = value

    def get_properties_node(self):
        return self.targets, self.value
