"""
  helper function
  bunch functions to avoid code duplication

"""
import os
import tarfile
import glob
import csv
import ast
import shutil
import json

from datetime import datetime


def search_path_file_of(directory, filename):
    """ Search the path of a specified file  for a given directory """
    _list = []
    for filepath in glob.glob(directory + '**/**', recursive=True):
        arr = filepath.split("/")
        if arr[len(arr) - 1] == filename:
            _list.append(filepath)

    return _list


def get_all_files(directory, extension):
    files = []

    for filepath in glob.glob(directory + '**/**', recursive=True):
        if filepath.endswith(extension):
            files.append(filepath)

    return files


def print_node(node):
    """
    print the node passed as a parameter
    :param node: node that we want to print
    """
    str_node = ast.dump(node, include_attributes=True, indent=4)
    print(str_node)


def Merge(dict1, dict2):
    """
    Merge two dictionaries
    :param dict1: the first dictionary
    :param dict2: the second dictionary
    :return: the merge dictionary
    """
    return dict1.update(dict2)


def copy_folder(folder, toDirectory):
    """ copy the inside of a folder inside another folder"""
    # copying the content of the folder inside new folder
    """if os.path.exists(toDirectory):
        shutil.copytree(folder, toDirectory)
        print("copy done")
    else:
        print("the folder {directory} does not exit for the copy".format(directory=toDirectory))"""

    try:
        # if path already exists, remove it before copying with copytree()
        if os.path.exists(toDirectory):
            print("starting the copy")
            shutil.rmtree(toDirectory)
            shutil.copytree(folder, toDirectory)
            print("copy done")
    except OSError as e:
        print('Directory not copied. Error: %s' % e)


def find_name_of(folder_path):
    """return the name of a folder"""
    slash = "/"
    if slash in folder_path:
        arr = folder_path.split(slash)
        cleaned_arr = list(filter(None, arr))
        return cleaned_arr[len(cleaned_arr) - 1]
    return folder_path


def create_directory(path_to_directory):
    """ create a director if it does not already exist """
    if not os.path.exists(path_to_directory):
        os.mkdir(path_to_directory)
        print(path_to_directory, "created")
    else:
        print("folder already exist")


def delete_folder(directory):
    """Delete the folder given as a parameter and its content"""
    try:
        shutil.rmtree(directory)
        print("deletion done")
    except OSError as e:
        print("Error: %s - %s." % (e.filename, e.strerror))


def save_into_csv_file(file_to_write, _list, _type, filename, _hash, date, verbose=False):
    """ write the result of the list inside a csv file """
    with open(file_to_write, 'a') as outfile:
        if len(_list) > 0:
            for l in _list:
                line = str(_type) + ',' + str(l[1]) + ',' + str(l[2]) + ',' + str(filename) + ',' + str(
                    _hash) + ',' + str(date)
                print(line, file=outfile)
        else:
            if verbose:
                line = str(_type) + ',' + 'none' + ',' + 'none' + ',' + str(filename)
                print(line, file=outfile)


def extract_project(directory, tar_file):
    """unzip a tar.gz file in a specified directory"""
    tar = tarfile.open(directory + tar_file, "r:gz")
    print("extracting", tar_file)
    tar.extractall(directory, numeric_owner=True)
    tar.close()


def drop_empty_folders(directory):
    """Verify that every empty folder removed in local storage."""
    os.chdir(directory)
    for dirpath, dirnames, filenames in os.walk(directory, topdown=False):
        if not dirnames and not filenames:
            os.rmdir(dirpath)


def write_row_in_csv(filename, row=[]):
    """write a row in the specified filename"""
    f = open(filename, "a")
    writer = csv.writer(f)

    # write the data
    if len(row) > 0:
        writer.writerow(row)
    f.close()


def write_in_json(filename, row):
    assert row is not None, "json data to write is missing"
    json_object = json.dumps(row, indent=4)
    f = open(filename, "a")
    f.write(json_object)
    f.close()


# code from https://thispointer.com/python-three-ways-to-check-if-a-file-is-empty/
def is_file_empty(file_path):
    """ Check if file is empty by confirming if its size is 0 bytes"""
    # Check if file exist and it is empty
    return os.path.exists(file_path) and os.stat(file_path).st_size == 0


def delete_file(filename):
    """
    delete the file given as parameter
    :param filename: the path to the file you want to delete
    """
    if os.path.exists(filename):
        os.remove(filename)
        print(f"file {filename} deleted")


def save_ast_node(code, filename):
    """ Turn the code into an ast node and save into a file"""
    code_str = ast.dump(ast.parse(code), indent=4)
    file = open(filename, "w")
    file.write(code_str)
    file.close()


def compile_code(code=None, filename=None):
    """ compile the code given as parameter"""
    assert code is not None, "You must pass a source code for the compilation"
    assert code is not None, "You must pass a filename for the compilation"
    compile(source=code, filename=filename, mode='exec')


def open_file(file_path):
    """ Open a file and return its content """
    with open(file_path, 'r') as fp:
        data = fp.readlines()
        data = ''.join(data)
        return data


def time_distance(d1, d2):
    """Calcul the time delta between two dates"""
    d1 = datetime.strptime(d1, "%Y-%m-%d")
    d2 = datetime.strptime(d2, "%Y-%m-%d")
    return abs((d2 - d1).days)


def compare_date(time1, time2):
    """
    compare the date passed as parameters
    :param time1: the fisrt date
    :param time2: the second date
    :return: True if time1 < time2
    """
    # retrieving time and hours
    d1, h1 = time1.split(" ")
    d2, h2 = time2.split(" ")

    # converting into a real date
    d1 = datetime.strptime(d1, "%Y-%m-%d")
    d2 = datetime.strptime(d2, "%Y-%m-%d")

    # removing + sign in the hours since they come like H:M:S+whatever
    plus_index_h1 = h1.find('+')
    if plus_index_h1 != -1:
        h1 = h1[:plus_index_h1]
    else:
        moins_index = h1.find('-')
        if moins_index != -1:
            h1 = h1[:moins_index]

    plus_index_h2 = h2.find('+')
    if plus_index_h2 != -1:
        h2 = h2[:plus_index_h2]
    else:
        moins_index = h2.find('-')
        if moins_index != -1:
            h2 = h2[:moins_index]

    # converting hours into real hours
    h1 = datetime.strptime(h1, "%H:%M:%S")
    h2 = datetime.strptime(h2, "%H:%M:%S")

    return d1 < d2 or (d1 == d2 and h1 < h2)


def extract_values_from_json(json_file, write_file):
    """ Extract values from a json array and save the results in a file"""

    header = ["commit_hash", "commit_msg", "date", "filename",
              "git", "churn", "loc", "mode", "isa", "what",
              "complexity", "size", "code", "refactoring-score",
              "strict-refactoring-score", "old-begin", "old-end", "new-begin", "new-end", "state"]

    write_row_in_csv(filename=write_file, row=header)

    def get_value_helper(json_arr, row, filename, state):
        for value in json_arr:
            what = value["change"]
            code = value["code"]
            size = value["size"]
            complexity = value["complexity"]
            isa = value["isa"]
            refactoring_score = value["refactoring-score"]
            strict_refactoring_score = value["strict-refactoring-score"]
            old_begin, old_end, new_begin, new_end = value["where"]
            new_row = row + [isa, what, complexity, size, code,
                             refactoring_score, strict_refactoring_score,
                             old_begin, old_end, new_begin, new_end, state]

            write_row_in_csv(filename=filename, row=new_row)

    # opening the json file
    fp = open(json_file)

    # getting all the jsons inside the file
    json_array = json.load(fp)

    for arr in json_array:
        date, hash, commit_msg, git = arr["committer-date"], arr["commit-sha"], arr["commit-msg"], arr["git"]
        files = arr["file-changes"]

        for file in files:
            metrics = file["file-metrics"]
            filename = file["file"]
            mode = file["mode"]
            state = str("1") if mode == "change-p.parsed-c.parsed" else str("0")
            changes = file["entity-changes"] if "entity-changes" in file else []
            unchanged = file["unchanged"] if "unchanged" in file else []

            current_entity = file["cur-entity"] if "cur-entity" in file else []
            prev_entity = file["prev-entity"] if "prev-entity" in file else []

            row = [hash, commit_msg, date, filename, git, metrics["churn"], metrics["loc"], mode]

            if len(changes) > 0:
                get_value_helper(json_arr=changes, row=row, filename=write_file, state=state)
            if len(unchanged) > 0:
                get_value_helper(json_arr=unchanged, row=row, filename=write_file, state=state)

            if len(current_entity) > 0 and not isinstance(current_entity, str):
                get_value_helper(json_arr=current_entity, row=row, filename=write_file, state=state)
            if len(prev_entity) > 0 and not isinstance(prev_entity, str):
                get_value_helper(json_arr=prev_entity, row=row, filename=write_file, state=state)


def merge_csv(csv_files, result_file):
    file_dict = dict()
    id = 1

    correspondance = open("correspondance.txt", "r")

    for csv_file in csv_files:
        print("Processing", csv_file)
        correspondance.write(csv_file + ", " + str(id) + "\n")
        with open(csv_file, 'r') as file:
            reader = csv.reader(file, delimiter=',')
            next(reader)
            for row in reader:
                filename = row[3]
                if filename not in file_dict.keys():
                    file_dict[filename] = id
                row += [str(file_dict[filename])]
                write_row_in_csv(filename=result_file, row=row)
        id += 1
        file.close()
