#!/usr/bin/bash

for place in $*

do
	pushd $place
	cntr=1

	niter=33

	while [ $cntr -lt $niter ]
	
	do
		echo $cntr
		ts_b=$(date +%s%N)
		
		pytest
		
		ts_a=$(date +%s%N)
		
		dt=$((($ts_a - $ts_b)/1000000))
		
		echo "#### Time taken,$place, $cntr, $ts_b, $ts_a, $dt" >>  "./run_log.txt"
		
		cntr=$(($cntr+1))
	done
	popd
done
exit
