# SANER 2024: Compare performance between in terms of exection speed between procedural programming and imperative programming

This research project is a comparative study between for loops and list comprehension in terms of performance.

### The python files

#### rules.py

This file contains the database of rules used to convert for into list comprehension and list comprehension into for loops. The files contains the following functions: 

* for_rewrite_rules: represent the rules for converting for loops into their equivalent list comprehension.
* list_comp_rewrite_rules: represent the rules for converting list comprehensions into their equivalent for loops.

#### model.py

The model.py file contains the differents models used to create the symbol table and retrace the value of a variable. It has:
* Class Symbol: it makes that for every occurence of any string we get each the same symbol.
* Class ScopeType: Enum used to represent different type of scope that we can have across the program.
* Class VariableType: Enum used to represent different type of variable that we can have across the program. 
* Class Scope: a scope is represented by:
        - a set of instructions (symbol, line, value)
        - a set of variable declared in the scope
        - its type
        - list of inner scope
        - link to the parent scope
        - iter variable if it is an iterable scope (i.e for-loop, while-loop)


#### symbolTable.py

This file contains:
* The class SymbolTable: The symbol table contains for each symbol the set of all scope where each symbol will be potentially used.

#### source.py

This file contains the code used to retrace the origin of a variable i.e In a symbol table when you want to retrace the value that contains a symbol. This file has the:
* Class Source that given a specific symbol at a specific line retrace its value if possible.


#### unit.py
This file contains:
* Class Unit: This class allow the insertion of new code snippet inside an AST tree
* The function extend_ast_tree: This function extend an AST tree by adding a new attribute "parent" to each node


#### testCases.py

This file contains all the test cases used to verify the good behavior of the codes written. It has:
* ForTestCases
* SymTableTestCases
* ListCompTestCases
* SourceTestCases


#### process.py

This file contains different function to help extract useful informations on AST tree node. For now the code can extract informattion about ast.For, ast.If and ast.Expr nodes.

#### performance.py

Testing the timing performance between the for loop transformation and list comp transformation

#### helper.py
Just a file to help avoid duplication. The file contains function to interact with files, folder and csv.

### stats.py
The most important file of the project. It takes all the python files of a given project and produce a json containing the statistics of the project about the number of for transformed.

#### Using the code
The use this project you must clone this project on your local computer and in your own file you will do the following:
```
in the source folder, open the terminal and run the following command:  python3 stats.py --p path_to_your_project
```


