% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_tungro.R
\name{predict_tungro}
\alias{predict_tungro}
\title{Predict Rice Tungro Disease Incidence}
\usage{
predict_tungro(wth, emergence)
}
\arguments{
\item{wth}{Weather data with a daily time-step, normally \acronym{NASA}
\acronym{POWER} data from \code{\link[=get_wth]{get_wth()}}, but any\code{\link[base:data.frame]{base::data.frame()}} object
that has the following properly named columns in them will work.\tabular{rl}{
   \strong{Field Name} \tab \strong{Value} \cr
   \emph{YYYYMMDD} \tab Date as Year Month Day (ISO8601) \cr
   \emph{DOY} \tab Consecutive day of year, commonly called "Julian date" \cr
   \emph{TEMP} \tab Mean daily temperature (°C) \cr
   \emph{RHUM} \tab Mean daily relative humidity (\%) \cr
   \emph{RAIN} \tab Mean daily rainfall (mm) \cr
   \emph{LAT} \tab \strong{Optional} latitude of weather observation. See LAT/LON Note. \cr
   \emph{LON} \tab \strong{Optional} longitude of weather observation. See LAT/LON Note. \cr
}}

\item{emergence}{Expected date of crop emergence}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} of disease intensity and infection
sites.  See \code{\link[=SEIR]{SEIR()}} for a full description of the column values.
}
\description{
A dynamic mechanistic simulation of tungro disease of rice, causal agents
\emph{Rice Tungro Spherical Virus} and \emph{Rice Tungro Bacilliform Virus}.
The model is driven by daily weather data, which can easily be accessed using
\code{\link[=get_wth]{get_wth()}} to download weather data from \acronym{NASA} \acronym{POWER} using
\CRANpkg{nasapower}.
}
\details{
The model represents site size as 1 rice plant.

Default values for this disease model are derived from Table 2 (Savary \emph{et
al.} 2012).
}
\note{
Adapted from \pkg{cropsim} package version 0.2.0-5 by Adam H. Sparks,
Department of Primary Industries and Regional Development, WA, AU.
Original model development: Serge Savary & Rene Pangga (IRRI).
Original \R implementation by Robert J. Hijmans, Rene Pangga, & Jorrel
Aunario (IRRI).

If the \code{wth} object provides \emph{LAT} and \emph{LON} columns, these will be included
in the output for mapping purposes. Both values must be present. These
columns are provided by default when using \code{\link[=get_wth]{get_wth()}}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# get weather for IRRI Zeigler Experiment Station in wet season 2000
wth <- get_wth(
  lonlat = c(121.25562, 14.6774),
  dates = c("2000-06-30", "2000-12-31")
)
tg <- predict_tungro(wth, emergence = "2000-07-01")
plot(x = tg$dates, y = tg$intensity, type = "l")
\dontshow{\}) # examplesIf}
}
\references{
Ling, K.C., and Tiongco, E.R., 1976. Effect of temperature on the
transmission of rice tungro virus by \emph{Nephotettix virescens}.
Philippine Phytopathology 11:46-57.

Ling, K.C., Palomar, M.K., 1966. Studies on rice plants infected with the
tungro virus at different ages. Philippines Agriculturist 50:165-177.

Rivera, C.T. and Ou, S.H., 1965. Leafhopper transmission of tungro disease of
rice. Plant Disease Reporter 49:127-131.

Savary, S., Nelson, A., Willocquet, L., Pangga, I., and Aunario, J.
Modeling and mapping potential epidemics of rice diseases globally. Crop
Protection, Volume 34, 2012, Pages 6-17, ISSN 0261-2194 DOI:
\doi{10.1016/j.cropro.2011.11.009}.

Tiongco, E.R., Cabunagan, R.C., Flores, Z.M., Hibino, H., and Koganezawa, H.,
1993. Serological monitoring of rice tungro disease development in the field:
its implication in disease management. Plant Disease 77:877-882. DOI:
\doi{10.1094/PD-77-0877}.
}
\seealso{
\code{\link[=SEIR]{SEIR()}}

Other predict functions: 
\code{\link{predict_bacterial_blight}()},
\code{\link{predict_brown_spot}()},
\code{\link{predict_leaf_blast}()},
\code{\link{predict_sheath_blight}()}
}
\author{
Serge Savary, Ireneo Pangga, Robert Hijmans, Jorrel Khalil Aunario
and Adam H. Sparks
}
\concept{predict functions}
