% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_sheath_blight.R
\name{predict_sheath_blight}
\alias{predict_sheath_blight}
\alias{predict_sb}
\title{Predict Rice Sheath Blight Intensity}
\usage{
predict_sheath_blight(wth, emergence)

predict_sb(wth, emergence)
}
\arguments{
\item{wth}{Weather data with a daily time-step, normally \acronym{NASA}
\acronym{POWER} data from \code{\link[=get_wth]{get_wth()}}, but any\code{\link[base:data.frame]{base::data.frame()}} object
that has the following properly named columns in them will work.\tabular{rl}{
   \strong{Field Name} \tab \strong{Value} \cr
   \emph{YYYYMMDD} \tab Date as Year Month Day (ISO8601) \cr
   \emph{DOY} \tab Consecutive day of year, commonly called "Julian date" \cr
   \emph{TEMP} \tab Mean daily temperature (°C) \cr
   \emph{RHUM} \tab Mean daily relative humidity (\%) \cr
   \emph{RAIN} \tab Mean daily rainfall (mm) \cr
   \emph{LAT} \tab \strong{Optional} latitude of weather observation. See LAT/LON Note. \cr
   \emph{LON} \tab \strong{Optional} longitude of weather observation. See LAT/LON Note. \cr
}}

\item{emergence}{Expected date of crop emergence}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} of disease intensity and infection
sites. See \code{\link[=SEIR]{SEIR()}} for a full description of the column values.
}
\description{
A dynamic mechanistic simulation of sheath blight disease of rice, causal
agent \emph{Rhizoctonia solani} AG1-1A Kühn. The model is driven by daily weather
data, which can easily be accessed using\code{\link[=get_wth]{get_wth()}} to download weather data
from \acronym{NASA} \acronym{POWER} using \CRANpkg{nasapower}.
}
\details{
The model represents site size as 1 rice plant's tiller.

Default values for this disease model are derived from Table 2 (Savary \emph{et
al.} 2012).

\code{\link[=predict_sb]{predict_sb()}} is a shorthand alias for \code{\link[=predict_sheath_blight]{predict_sheath_blight()}}.
}
\note{
Adapted from \pkg{cropsim} package version 0.2.0-5 by Adam H. Sparks,
Department of Primary Industries and Regional Development, WA, AU.
Original model development: Serge Savary & Rene Pangga (IRRI).
Original \R implementation by Robert J. Hijmans, Rene Pangga, & Jorrel
Aunario (IRRI).

If the \code{wth} object provides \emph{LAT} and \emph{LON} columns, these will be included
in the output for mapping purposes. Both values must be present. These
columns are provided by default when using \code{\link[=get_wth]{get_wth()}}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# get weather for IRRI Zeigler Experiment Station in wet season 2000
wth <- get_wth(
  lonlat = c(121.25562, 14.6774),
  dates = c("2000-06-30", "2000-12-31")
)
sb <- predict_sheath_blight(wth, emergence = "2000-07-01")
plot(x = sb$dates, y = sb$intensity, type = "l")
\dontshow{\}) # examplesIf}
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# use shorthand function
sb <- predict_sb(wth, emergence = "2000-07-01")
plot(x = sb$dates, y = sb$intensity, type = "l")
\dontshow{\}) # examplesIf}
}
\references{
Castilla, N.P., Leano, R.M., Elazegui, F.A., Teng, P.S., Savary,
S., 1996. Effects of plant contacts, inoculation pattern, leaf wetness
regime, and nitrogen supply on inoculum efficiency in rice sheath blight.
Journal of Phytopathology 144:187-192.

Gross, M.K., Santini, J.B., Tikhonova, I. and Latin, R. 1998. The influence
of temperature and leaf wetness duration on infection of perennial ryegrass
by \emph{Rhizoctonia solani}. Plant Disease 82:1012-1016. DOI:
\doi{10.1094/PDIS.1998.82.9.1012}.

Hashiba, T. and Ijiri, T., 1989. Estimation of yield loss and computerized
forecasting system (BLIGHTAS) for rice sheath blight disease. International
Symposium on Tropical Agricultural Research: Crop losses due to disease
outbreaks in the tropics and countermeasures. Tropical Agricultural
Research Series (Japan) No. 22 pp. 163-171.

Savary, S., Willocquet, L., Teng, P.S., 1997. Modelling sheath blight
epidemics on rice tillers. Agricultural Systems 55:359-384. DOI:
\doi{10.1016/S0308-521X(97)00014-0}.

Savary, S., Castilla, N.P., Willocquet, L. 2001. Analysis of the spatio-
temporal structure of rice sheath blight epidemics in a farmer's field.
Plant Pathology 50:53-68. DOI: \doi{10.1046/j.1365-3059.2001.00531.x}.

Savary, S., Nelson, A., Willocquet, L., Pangga, I., and Aunario, J. Modeling
and mapping potential epidemics of rice diseases globally. Crop Protection,
Volume 34, 2012, Pages 6-17, ISSN 0261-2194 DOI:
\doi{10.1016/j.cropro.2011.11.009}.

Sharma, N.R., Teng, P.S., Olivares, F.M., 1990. Effect of rice growth stage
on sheath blight (ShB) development and yield loss. International Rice
Research Newsletter 15:19-20.

Tu, C.C., Chang, Y.C., Wang, C.W., 1979. Studies on the ecology of
\emph{Rhizoctonia solani}, the causal organism of rice sheath blight. National
Science Council Monthly, ROC 7:1208-1219.
}
\seealso{
\code{\link[=SEIR]{SEIR()}}

Other predict functions: 
\code{\link{predict_bacterial_blight}()},
\code{\link{predict_brown_spot}()},
\code{\link{predict_leaf_blast}()},
\code{\link{predict_tungro}()}
}
\author{
Serge Savary, Ireneo Pangga, Robert Hijmans, Jorrel Khalil Aunario,
and Adam H. Sparks
}
\concept{predict functions}
