% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_brown_spot.R
\name{predict_brown_spot}
\alias{predict_brown_spot}
\alias{predict_bs}
\title{Predict Rice Brown Spot Intensity}
\usage{
predict_brown_spot(wth, emergence)

predict_bs(wth, emergence)
}
\arguments{
\item{wth}{Weather data with a daily time-step, normally \acronym{NASA}
\acronym{POWER} data from \code{\link[=get_wth]{get_wth()}}, but any\code{\link[base:data.frame]{base::data.frame()}} object
that has the following properly named columns in them will work.\tabular{rl}{
   \strong{Field Name} \tab \strong{Value} \cr
   \emph{YYYYMMDD} \tab Date as Year Month Day (ISO8601) \cr
   \emph{DOY} \tab Consecutive day of year, commonly called "Julian date" \cr
   \emph{TEMP} \tab Mean daily temperature (°C) \cr
   \emph{RHUM} \tab Mean daily relative humidity (\%) \cr
   \emph{RAIN} \tab Mean daily rainfall (mm) \cr
   \emph{LAT} \tab \strong{Optional} latitude of weather observation. See LAT/LON Note. \cr
   \emph{LON} \tab \strong{Optional} longitude of weather observation. See LAT/LON Note. \cr
}}

\item{emergence}{Expected date of crop emergence}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} of disease intensity and infection
sites. See \code{\link[=SEIR]{SEIR()}} for a full description of the column values.
}
\description{
A dynamic mechanistic simulation of rice brown spot, causal agent
\emph{Cochliobolus miyabeanus}. The model is driven by daily weather data, which
can easily be accessed using\code{\link[=get_wth]{get_wth()}} to download weather data from
\acronym{NASA} \acronym{POWER} using \CRANpkg{nasapower}.
}
\details{
The model represents site size as 10
\ifelse{html}{\out{mm<sup>2</sup>}}{\eqn{mm^2}} of a rice plant's leaf.

Default values for this disease model are derived from Table 2 (Savary
\emph{et al.} 2012).

\code{\link[=predict_bs]{predict_bs()}} is a shorthand alias for \code{\link[=predict_brown_spot]{predict_brown_spot()}}.
}
\note{
Adapted from \pkg{cropsim} package version 0.2.0-5 by Adam H. Sparks,
Department of Primary Industries and Regional Development, WA, AU.
Original model development: Serge Savary & Rene Pangga (IRRI).
Original \R implementation by Robert J. Hijmans, Rene Pangga, & Jorrel
Aunario (IRRI).

If the \code{wth} object provides \emph{LAT} and \emph{LON} columns, these will be included
in the output for mapping purposes. Both values must be present. These
columns are provided by default when using \code{\link[=get_wth]{get_wth()}}.

The optimum temperature for brown spot as presented in Table 2 of
Savary \emph{et al.} 2012 has a typo. The optimal value should be 25 °C, not
20 °C as shown. The correct value, 25 °C, is used in this implementation.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# get weather for IRRI Zeigler Experiment Station in wet season 2000
wth <- get_wth(
  lonlat = c(121.25562, 14.6774),
  dates = c("2000-06-30", "2000-12-31")
)
bs <- predict_brown_spot(wth, emergence = "2000-07-01")
plot(x = bs$dates, y = bs$intensity, type = "l")
\dontshow{\}) # examplesIf}
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# use shorthand function
bs <- predict_bs(wth, emergence = "2000-07-01")
plot(x = bs$dates, y = bs$intensity, type = "l")
\dontshow{\}) # examplesIf}
}
\references{
Klomp, A.O., 1977. Early senescence of rice and \emph{Drechslera
oryzae} in the Wageningen polder, Surinam. PhD Thesis, 97p.

Levy, Y. and Cohen, Y., 1980. Sporulation of \emph{Helminthosporium turcicum} on
sweet corn: Effects of temperature and dew period. Canadian Journal of Plant
Pathology 2:65-69. DOI: \doi{10.1080/07060668009501440}.

Luo Wei-Hong, 1996. Simulation and measurement of leaf wetness formation in
paddy rice crops. PhD, Wageningen Agricultural University, 87 p.

Padmanabhan, S.Y. and Ganguly, D. 1954. Relation between the age of rice
plant and its susceptibility to \emph{Helminthosporium} and blast disease.
Proceedings of the Indian Academy of Sciences B 29:44-50.

Sarkar, A.K. and Sen Gupta, P.K., 1977. Effect of temperature and humidity on
disease development and sporulation of \emph{Helminthosporium oryzae} on rice.
Indian Phytopathology 30:258-259.

Savary, S., Nelson, A., Willocquet, L., Pangga, I., and Aunario, J. Modeling
and mapping potential epidemics of rice diseases globally. Crop Protection,
Volume 34, 2012, Pages 6-17, ISSN 0261-2194 DOI:
\doi{10.1016/j.cropro.2011.11.009}.

Waggoner. P.E., Horsfall, J.G., and Lukens, R.J. 1972. EPIMAY. A Simulator of
Southern Corn Leaf Blight. Bulletin of the Connecticut Experiment Station,
New Haven, 85 p.
}
\seealso{
\code{\link[=SEIR]{SEIR()}}

Other predict functions: 
\code{\link{predict_bacterial_blight}()},
\code{\link{predict_leaf_blast}()},
\code{\link{predict_sheath_blight}()},
\code{\link{predict_tungro}()}
}
\author{
Serge Savary, Ireneo Pangga, Robert Hijmans, Jorrel Khalil Aunario
}
\concept{predict functions}
