% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_wth.R
\name{get_wth}
\alias{get_wth}
\title{Get Weather Data for Use in epicrop Modelling}
\usage{
get_wth(lonlat, dates, duration)
}
\arguments{
\item{lonlat}{A numeric vector of geographic coordinates for a cell or region
entered as x, y coordinates.}

\item{dates}{A character vector of start and end dates in that order.}

\item{duration}{A numeric value indicating how many days a single
growing season being simulated is to be.  If this is used, only the start
date will be used and the end date will be ignored if supplied.  This must
match the \code{duration} parameter value passed along to \code{\link[=SEIR]{SEIR()}} or any of the
\code{predict} family of functions.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} of weather data, dates and
geolocation information (LAT/LON values) suitable for use in \pkg{epicrop}
with the following columns:\tabular{rl}{
   \strong{Field Name} \tab \strong{Value} \cr
   \emph{YYYYMMDD} \tab Date as Year Month Day (ISO8601) \cr
   \emph{DOY} \tab Consecutive day of year, commonly called "Julian date" \cr
   \emph{TEMP} \tab Mean daily temperature (°C) \cr
   \emph{RHUM} \tab Mean daily relative humidity (\%) \cr
   \emph{RAIN} \tab Mean daily rainfall (mm) \cr
   \emph{LAT} \tab Latitude of area of interest \cr
   \emph{LON} \tab Longitude of area of interest \cr
}
}
\description{
This function is a wrapper for the \code{\link[nasapower:get_power]{nasapower::get_power()}} with predefined
parameters suitable for use in \pkg{epicrop}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# get weather for IRRI Zeigler Experiment Station in wet season 2000 from the
# default NASA POWER data.
power <- get_wth(
  lonlat = c(121.25562, 14.6774),
  dates = c("2000-06-30", "2000-12-31")
)

# get 120 days of weather for IRRI Zeigler Experiment Station in wet season
# 2000 by specifying the duration but not the end-date and specifying to use
# POWER data.
power <- get_wth(
  lonlat = c(121.25562, 14.6774),
  dates = "2000-06-30",
  duration = 120,
  source = "nasapower"
)
\dontshow{\}) # examplesIf}
}
\author{
Adam H. Sparks, \email{adamhsparks@gmail.com}
}
