% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epicrop-package.R
\docType{package}
\name{epicrop-package}
\alias{epicrop}
\alias{epicrop-package}
\title{epicrop: Simulation Modelling of Crop Diseases Using a Susceptible-Exposed-Infectious-Removed (SEIR) Model}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Generic simulation modelling of crop diseases using a Susceptible- Exposed-Infectious-Removed ('SEIR') model. This type of model was first described in botanical epidemiology by Zadoks (1971) \doi{10.1094/Phyto-61-600} and implemented in the 'EPIRICE' model by Savary et al. (2012) \doi{10.1016/j.cropro.2011.11.009} detailing the model's development, use and results from modeling global unmanaged epidemics of rice diseases for five major rice diseases, bacterial blight, brown spot, leaf blast, sheath blight and tungro. Specific functions are provided to simulate all of these diseases with a generic 'SEIR' model function that is suitable for parameterising for use with other pathosystems as demonstrated in Savary et al. 2012.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/adamhsparks/epicrop/}
  \item Report bugs at \url{https://github.com/adamhsparks/epicrop/issues}
}

}
\author{
\strong{Maintainer}: Adam H. Sparks \email{adamhsparks@gmail.com} (\href{https://orcid.org/0000-0002-0061-8359}{ORCID})

Authors:
\itemize{
  \item Robert Hijmans \email{robert.hijmans@gmail.com} (\href{https://orcid.org/0000-0001-5872-2872}{ORCID}) (Original R implementation) [translator]
  \item Serge Savary \email{serge.savary@toulouse.inra.fr} (\href{https://orcid.org/0000-0002-6867-180X}{ORCID}) (Model conception and development in Stella) [conceptor]
  \item Ireno Pangga \email{ibpangga@yahoo.com} (Model conception, development in Stella and original R implementation) [translator]
  \item Jorrel Aunario \email{j.aunario@irri.org} (Original R implementation) [translator]
}

Other contributors:
\itemize{
  \item Aji Sukarta \email{aji.ixb@gmail.com} (Helped fix bug related to SEIR model and establishment date) [contributor]
  \item Emerson Del Ponte \email{delponte@ufv.br} (\href{https://orcid.org/0000-0003-4398-409X}{ORCID}) (Suggested fixes for several typos in the documentation) [contributor]
}

}
\keyword{internal}
