% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEIR.R
\name{SEIR}
\alias{SEIR}
\title{Susceptible-Exposed-Infectious-Removed (SEIR) Model Framework}
\usage{
SEIR(
  wth,
  emergence,
  onset,
  duration,
  rhlim,
  rainlim,
  H0,
  I0,
  RcA,
  RcT,
  RcOpt,
  p,
  i,
  Sx,
  a,
  RRS,
  RRG
)
}
\arguments{
\item{wth}{a \code{data.frame} of weather on a daily time-step containing data
with the following field names.\tabular{rl}{
   \strong{Field Name} \tab \strong{Value} \cr
   \emph{YYYYMMDD} \tab Date as Year Month Day (ISO8601) \cr
   \emph{DOY} \tab Consecutive day of year, commonly called "Julian date" \cr
   \emph{TEMP} \tab Mean daily temperature (°C) \cr
   \emph{RHUM} \tab Mean daily relative humidity (\%) \cr
   \emph{RAIN} \tab Mean daily rainfall (mm) \cr
   \emph{LAT} \tab \strong{Optional} latitude of weather observation, see LAT/LON Note \cr
   \emph{LON} \tab \strong{Optional} longitude of weather observation, see LAT/LON Note \cr
}}

\item{emergence}{expected date of plant emergence (or transplanting for rice)
entered in \code{YYYY-MM-DD} format (character).  Described in Table 1 of Savary
\emph{et al.} 2012 and Table 1 of Savary \emph{et al.} 2015.}

\item{onset}{expected number of days until the onset of disease after
emergence date (day, integer).  Described in Table 1 of Savary \emph{et al.}
2012 and Table 1 of Savary \emph{et al.} 2015.}

\item{duration}{simulation duration \emph{i.e.}, growing season length (day,
integer).  Described in Table 1 of Savary \emph{et al.} 2012 and Table 1 of
Savary \emph{et al.} 2015.}

\item{rhlim}{relative humidity value threshold to decide whether leaves are
wet or not (numeric).  Described in Table 1 of Savary \emph{et al.} 2012. Savary
\emph{et al.} 2012 used 90\%.}

\item{rainlim}{rainfall amount (mm) threshold to decide whether leaves are
wet or not (numeric).  Described in Table 1 of Savary \emph{et al.} 2012.  Savary
\emph{et al.} 2012 used 5mm.}

\item{H0}{initial number of plant's healthy sites (integer).  Described in
Table 1 of Savary \emph{et al.} 2012 and Table 1 of Savary \emph{et al.} 2015.}

\item{I0}{initial number of infective sites (integer).  Described in Table 1
of Savary \emph{et al.} 2012 and Table 1 of Savary \emph{et al.} 2015.}

\item{RcA}{modifier for \emph{Rc} (the basic infection rate corrected for
removals) for crop age (numeric vector).  Described in Table 1 of Savary
\emph{et al.} 2012 Table 1 of Savary \emph{et al.} 2015.}

\item{RcT}{modifier for \emph{Rc} (the basic infection rate corrected for
removals) for temperature (numeric vector).  Described in Table 1 of Savary
\emph{et al.} 2012 and Table 1 of Savary \emph{et al.} 2015.}

\item{RcOpt}{potential basic infection rate corrected for removals (numeric).
Derived from Table 1 of Savary \emph{et al.} 2012 and Table 1 of Savary \emph{et al.}
2015.}

\item{p}{duration of latent period (day, integer).  Described in Table 1 of
Savary \emph{et al.} 2012 and Table 1 of Savary \emph{et al.} 2015.}

\item{i}{duration of infectious period (day, integer).  Described in Table 1
of Savary \emph{et al.} 2012 and Table 1 of Savary \emph{et al.} 2015.}

\item{Sx}{maximum number of sites (integer).  Described in Table 1 of Savary
\emph{et al.} 2012 and Table 1 of Savary \emph{et al.} 2015.}

\item{a}{aggregation coefficient, values are from 1 to >1 (numeric).
Described in Table 1 of Savary \emph{et al.} 2012 and Table 1 of Savary \emph{et al.}
2015.  See further details in \strong{\emph{a} - Aggregation} section.}

\item{RRS}{relative rate of physiological senescence (numeric).  Described in
Table 1 of Savary \emph{et al.} 2012 and Table 1 of Savary \emph{et al.} 2015.}

\item{RRG}{relative rate of growth (numeric).  Described in Table 1 of Savary
\emph{et al.} 2012 and Table 1 of Savary \emph{et al.} 2015.}
}
\value{
A \code{\link[=data.table]{data.table()}} containing the following columns:

\describe{
\item{simday}{Zero indexed day of simulation that was run}
\item{dates}{Date of simulation}
\item{sites}{Total number of sites present on day "x"}
\item{latent}{Number of latent sites present on day "x"}
\item{infectious}{Number of infectious sites present on day "x"}
\item{removed}{Number of removed sites present on day "x"}
\item{senesced}{Number of senesced sites present on day "x"}
\item{ratinf}{Rate of infection}
\item{rtransfer}{Rate of transfer from latent to infectious sites}
\item{rgrowth}{Rate of growth of healthy sites}
\item{rsenesced}{Rate of senescence of healthy sites}
\item{diseased}{Number of diseased (latent + infectious + removed) sites on day "x"}
\item{intensity}{Proportion of diseased (latent + infectious + removed) sites per total sites not including removed sites on day "x"}
\item{AUDPC}{Area under the disease progress curve \acronym{AUDPC} for the simulation}
\item{lat}{Latitude value if provided by the \code{wth} object}
\item{lon}{Longitude value if provided by the \code{wth} object}
}
}
\description{
This function is originally used by specific disease models in
\sQuote{EPIRICE} to model disease intensity of several rice diseases.  Given
proper values it can be used with other pathosystems as well.
}
\section{\emph{a} - Aggregation}{
When \emph{a} is set to \code{1} the assumption is that that there is no disease
aggregation with new infections occurring at random among the healthy sites.
When \emph{a} is greater than \code{1} there is aggregation in the disease occurrence,
the pathogen is unable to access the entire population of healthy sites,
which results in disease aggregation. Refer to Savary \emph{et al.} (2012) for
greater detail.
}

\section{\emph{LAT}/\emph{LON}}{
If the \code{wth} object provides \emph{LAT} and \emph{LON} columns, these will be included
in the output for mapping purposes. Both values must be present. These
columns are provided by default when using \code{\link[=get_wth]{get_wth()}}.
}

\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# get weather for IRRI Zeigler Experiment Station in wet season 2000
wth <- get_wth(
  lonlat = c(121.25562, 14.6774),
  dates = c("2000-06-30", "2000-12-31")
)

# provide suitable values for brown spot intensity
RcA <-
  cbind(c(0L, 20L, 40L, 60L, 80L, 100L, 120L),
        c(0.35, 0.35, 0.35, 0.47, 0.59, 0.71, 1.0))
RcT <-
  cbind(c(15L, 20L, 25L, 30L, 35L, 40L),
        c(0, 0.06, 1.0, 0.85, 0.16, 0))
emergence <- "2000-07-15"

(SEIR(
  wth = wth,
  emergence = emergence,
  onset = 20,
  duration = 120,
  rhlim = 90,
  rainlim = 5,
  RcA = RcA,
  RcT = RcT,
  RcOpt = 0.61,
  p =  6,
  i = 19,
  H0 = 600,
  I0 = 1,
  a = 1,
  Sx = 100000,
  RRS = 0.01,
  RRG = 0.1
))
\dontshow{\}) # examplesIf}
}
\references{
Sparks, A.H., P.D. Esker, M. Bates, W. Dall' Acqua, Z. Guo, V. Segovia, S.D.
Silwal, S. Tolos, and K.A. Garrett, 2008. Ecology and Epidemiology in R:
Disease Progress over Time. \emph{The Plant Health Instructor}.
DOI: \doi{10.1094/PHI-A-2008-0129-02}.

Madden, L. V., G. Hughes, and F. van den Bosch. 2007. The Study of Plant
Disease Epidemics. American Phytopathological Society, St. Paul, MN.
DOI: \doi{10.1094/9780890545058}.

Savary, S., Nelson, A., Willocquet, L., Pangga, I., and Aunario,
J. Modeling and mapping potential epidemics of rice diseases globally. \emph{Crop
Protection}, Volume 34, 2012, Pages 6-17, ISSN 0261-2194 DOI:
\doi{10.1016/j.cropro.2011.11.009}.
}
\seealso{
\code{SEIR()} is called by the following specific disease modelling functions:
\itemize{
\item \code{\link[=predict_bacterial_blight]{predict_bacterial_blight()}},
\item \code{\link[=predict_brown_spot]{predict_brown_spot()}},
\item \code{\link[=predict_leaf_blast]{predict_leaf_blast()}},
\item \code{\link[=predict_sheath_blight]{predict_sheath_blight()}},
\item \code{\link[=predict_tungro]{predict_tungro()}}
}
}
\author{
Adam H. Sparks, \email{adamhsparks@gmail.com}
}
