## Wheel Test

This directory is dedicated to tests that require a built TensorFlow wheel
file for testing, such as:

* Ensuring the entire API is importable
* Testing downstream projects against the wheel

Ensure you have Bazel installed and accessible from your command line.

These tests use hermetic Python. They also require a built TensorFlow wheel file
and a requirements_lock file. The requirements_lock file is generated by the
[requirements_updater](https://github.com/tensorflow/tensorflow/tree/master/ci/official/requirements_updater)
tool using the path to this wheel file.

### Hermetic Python

For details about hermetic Python and setting its toolchain version, see
[requirements updater readme](https://github.com/tensorflow/tensorflow/blob/master/ci/official/requirements_updater/README.md)

### Prerequisites for Local Testing

To run tests locally, follow these steps:

1.  Navigate to the relevant directory:
    ```
    cd ci/official/wheel_test
    ```
2.  Run a script for creating requirements file:
    ```
    bash update_requirements.sh <path_to_tensorflow_wheel> <python_version>
    e.g.:
    bash update_requirements.sh /tmp/tensorflow-2.14.0-cp311-cp311-linux_x86_64.whl 3_11
    ```

#### Requirements Updater Script
This script automates the process of updating TensorFlow requirements for a
specific Python version.

##### Parameters
`path_to_tensorflow_wheel`: The local path to the TensorFlow wheel file.
Example: `/tmp/tensorflow-2.14.0-cp311-cp311-linux_x86_64.whl`

`python_version`: The target Python version, replacing `.` with `_`.
Example: For Python 3.11, use `3_11`

The script performs the following steps:

1. Navigates to the `../requirements_updater` directory.
2. Creates a `requirements_wheel_test.in` file and specifies the path
to the actual TensorFlow wheel.
3. Creates a `requirements_lock_<python_version>.txt` file.
4. Updates the `requirements_lock_<python_version>.txt` file using
a Bazel command.
5. Moves the updated `requirements_lock_<python_version>.txt` file
to the `../wheel_test/` directory.


### How it Works in the Presubmit Job

`_requirements_lock` files will be generated by the presubmit job. A detailed
description will be provided once it's integrated into presubmit.

### test_import_api_packages

This Python test verifies whether the API v2 packages can be imported from the
current build. It utilizes the `_api/v2/api_packages.txt` list of packages from
the local wheel file specified in the `requirements_lock_<python_version>.txt`.

Packages are imported one by one in alphabetical order during runtime.

The test doesn't identify package's order-dependent issues; for instance,
importing "tf.foo" followed by "tf.bar" won't reveal that "tf.bar" depends on
"tf.foo" being imported first.

The `_api/v2/api_packages.txt` file is generated during the TensorFlow API v2
init files creation process and is subsequently stored in the wheel file after
the build. It also contains a few paths that cannot be directly imported. These
paths point to attributes or sub-modules within a module's namespace, but they
don't correspond to an actual file or directory on the filesystem. The list of
such paths is stored in the packages_for_skip variable and will be skipped
during the test.

##### How to Build

```
bazel build //:test_import_api_packages
```

##### How to Run

```
bazel test //:test_import_api_packages --test_output=all
```
