function roi_segmentation(fig)

nii_view = getappdata(fig,'nii_view');

if ~isfield(nii_view.handles,'vox_select')
    
    nImg = nii_view.numscan;
    VoxIntensity = cell(3,nImg+1);
    VoxIntensity{1,1} = 0;
    VoxIntensity{2,1} = 0;
    VoxIntensity{3,1} = 0;
    
    setappdata(fig, 'VoxIntensity', VoxIntensity);    set(fig,'Position',[0.23 0.08 0.70 0.85]);

%     hSelect = figure('unit','normal','position',[0.075 0.08 0.15 0.875]);
    hSelect = figure('unit','normal','position',[0.0633  0.0801  0.1602  0.8711],...
         'menubar', 'none','name','Voxel Intensities','numbertitle','off');
%     set(hSelect, 'menubar', 'none','name','Voxel Intensities','numbertitle','off');

    hButton1 = uicontrol('Parent',hSelect,'Style', 'pushbutton', 'String', 'Save',...
    'Units','normalized','Position', [0.1 0.92 0.3 0.05], 'Callback', sprintf('save_dtipoints(%d)',fig));

    hButton2 = uicontrol('Parent',hSelect,'Style', 'pushbutton', 'String', 'LDA',...
    'Units','normalized','Position', [0.6 0.92 0.3 0.05], 'Callback', sprintf('lda_analysis(%d)',fig));
    
    % Create the button group.
    hButton = uibuttongroup('Parent',hSelect,'visible','on','Units','normalized',...
        'Position',[0.217 0.87 0.68 0.025],'BorderType','beveledout');
    % Create three radio buttons in the button group.
    nii_view.handles.grayM = uicontrol('Style','Radio',...
        'Units','normalized','pos',[0.12 0.1 0.15 0.9],'parent',hButton);
    nii_view.handles.whiteM = uicontrol('Style','Radio',...
        'Units','normalized','pos',[0.44 0.1 0.15 0.9],'parent',hButton);
    nii_view.handles.csf = uicontrol('Style','Radio',...
        'Units','normalized','pos',[0.78 0.1 0.15 0.9],'parent',hButton);
    
    % points to be acquired in WM, GM, and CSF
    npoints = 8; 
    points = cell(npoints,3);
    nii_view.handles.vox_select = uitable('Parent',hSelect,'Units','normalized','Position',...
                [0.07 0.695 0.83 0.175], 'Data', points,... 
                'ColumnName', {'Gray M', 'White M', 'CSF'},...
                'Columnwidth',{46.4 46.4 46.4});
    % Mean
    nii_view.handles.vox_mean = uitable('Parent',hSelect,'Units','normalized','Position',...
                [0.07 0.354 0.91 0.30], 'Data', cell(nii_view.numscan,3),... 
                'ColumnName', {'Gray M', 'White M', 'CSF'},'Columnformat',{'bank' 'bank' 'bank'},...
                'Columnwidth',{46.4 46.4 46.4});     
            
    uicontrol('Parent',hSelect,'Style','text','String','Mean',...
    'Units','normalized','Position', [0.1 0.66 0.90 0.02],...
    'BackgroundColor', [0.8 0.8 0.8]);
    
    % Standard deviation
    nii_view.handles.vox_stddev = uitable('Parent',hSelect,'Units','normalized','Position',...
                [0.07 0.02 0.91 0.30], 'Data', cell(nii_view.numscan,3),... 
                'ColumnName', {'Gray M', 'White M', 'CSF'},'Columnformat',{'bank' 'bank' 'bank'},...
                'Columnwidth',{46.4 46.4 46.4});
            
    uicontrol('Parent',hSelect,'Style','text','String','Standard Deviation',...
    'Units','normalized','Position', [0.1 0.325 0.90 0.02],...
    'BackgroundColor', [0.8 0.8 0.8]);

    setappdata(fig,'nii_view',nii_view);

end