      DOUBLE PRECISION FUNCTION W3FA09   (TK)
C$$$  SUBROUTINE DOCUMENTATION BLOCK ***
C
C SUBR: W3FA09   - TEMPERATURE TO SATURATION VAPOR PRESSURE
C   AUTHOR: CHASE, P.          ORG: W345          DATE:    OCT 78
C   UPDATE: JONES, R.E.        ORG: W342          DATE: 26 JUN 84
C
C ABSTRACT: COMPUTES SATURATION VAPOR PRESSURE IN KILOPASCALS GIVEN
C   TEMPERATAURE IN KELVINS.
C
C PROGRAM HISTORY LOG:
C   78-10-01  P.CHASE
C   84-06-26  R.E.JONES  CHANGE TO IBM VS FORTRAN
C   84-06-26  R.E.JONES  CHANGE TO MICROSOFT FORTRAN 4.10
C   91-08-06  R.E.JONES  CHANGE TO SVS 386 FORTRAN 2.8a
C
C USAGE:  VP = W3FA09 (TK)
C
C   INPUT:
C     'TK' - REAL*4 TEMPERATURE IN KELVINS. IF TK < 223.16, THE VALUE
C            223.16 WILL BE USED.  IF TK > 323.16, THE VALUE 323.16
C            WILL BE USED AS THE ARGUMENT. 'TK' ITSELF IS UNCHANGED.
C   OUTPUT:
C     'VP' - SATURATION VAPOR PRESSURE IN KILOPASCALS.
C            0.0063558 < VP < 12.3395
C
C   NOTES: W3FA09 MAY BE DECLARED REAL*8 SO THAT A REAL*8 VALUE IS
C     RETURNED, BUT NO INCREASE IN ACCURACY IS IMPLIED.
C
C   EXIT STATES: NONE
C
C   EXTERNAL REFERENCES: NONE
C
C ATTRIBUTES:
C   LANGUAGE: SVS 386 FORTRAN 2.8a
C   MACHINE:  IBM PC, AT, PS/2, 386, 486, CLONES.
C
C$$$
C
C THE CHEBYSHEV COEFFICIENTS ARE IN ARRAY C, LOW-ORDER TERM FIRST.
C
      DOUBLE PRECISION   ARG,H0,H1,H2
      DOUBLE PRECISION   C(9)
      DATA C /
     1 0.313732865927D+01,  0.510038215244D+01,  0.277816535655D+01,
     2 0.102673379933D+01,  0.254577145215D+00,  0.396055201295D-01,
     3 0.292209288468D-02, -0.119497199712D-03, -0.352745603496D-04 /
C
C SCALE TK TO RANGE -2, +2 FOR SERIES EVALUATION.  INITIALIZE TERMS.
C
      ARG = -1.09264D1+4.0D-2*DMAX1(223.16D0,DMIN1(323.16D0,DBLE(TK)))
      H0 = 0D0
      H1 = 0D0
C
C EVALUATE CHEBYSHEV POLYNOMIAL
C
      DO 10 I=1,9
      H2 = H1
      H1 = H0
      H0 = ARG*H1-H2+C(10-I)
 10   CONTINUE
      W3FA09 = 0.5D0*(C(1)-H2+H0)
      RETURN
      END
