#!/bin/bash

# Settings
SITE_LIST=/home/563/ab7412/CABLE_run/PEST/OzFLUX_sitelist_GT_All.txt
PARAM_DIR=/home/563/ab7412/CABLE_run/future_runs/params
SITE_PARAMS=$PARAM_DIR/site_params
RUN_CABLE_DIR=$PWD
RUN_SCRIPT=/home/563/ab7412/CABLE_run/future_runs/run_cable-pop.sh
LOG_DIR=/scratch/x45/ab7412/GPP_temp/site_runs/logs

######################
# Script
######################
sites=$(cut -f 1 $SITE_LIST)
ind=1

# 1. start site loop

for site in $sites; do

  echo starting site $site
  let "ind=ind+1"

  # 2. Get site name from SITE_LIST and change site name in run_cable-pop.sh script
  sed -i "/    site=/c\    site=$site" $RUN_SCRIPT

  # 3. Get latitude and longitude from SITE_LIST and update run_cable-pop.sh script
    site_lat=$(sed -n "$ind p" $SITE_LIST | cut -f 4)
    site_lon=$(sed -n "$ind p" $SITE_LIST | cut -f 5)

    echo "latitude is " $site_lat " longitude is " $site_lon

    sed -i "/site_lat=/c\    site_lat=$site_lat" $RUN_SCRIPT
    sed -i "/site_lon=/c\    site_lon=$site_lon" $RUN_SCRIPT

  # 4. copy site parameter files to parameter directory

    #for site specific params
    cp ${SITE_PARAMS}/veg_params_${site}.txt /${PARAM_DIR}/def_veg_params.txt
    cp ${SITE_PARAMS}/pftlookup_${site}.csv /${PARAM_DIR}/pftlookup.csv

    #for JK global params
#    cp ${SITE_PARAMS}/def_veg_params.txt /${PARAM_DIR}/def_veg_params.txt
#    cp ${SITE_PARAMS}/pftlookup.csv /${PARAM_DIR}/pftlookup.csv
    
    # 5. Change PBS job name and Submit run_cable-pop.sh script
    sed -i "/#PBS -N/c\#PBS -N $site" $RUN_SCRIPT
    qsub -o ${LOG_DIR}/pbsjob_$site.out $RUN_SCRIPT

done

