# Variable influence of photosynthetic thermal acclimation on future carbon uptake in Australian wooded ecosystems under climate change

This dataset contains the files related to the experiment detailed in the manuscript published in Global Change Biology whereby we used the CABLE-POP landsurface model forced with HadGEM2-ES climate forcing data to examine the influence of photosynthetic thermal acclimation on GPP, NPP and live tree carbon storage in 17 wooded ecosystems in Australia.

Included in this dataset are the parameter files (file extension .txt and .csv), setting files (file extension .nml) and runscripts (file extension .sh) needed to reproduce the experiment. In addition we provide the simulation output needed to examine our results. Full details of the methods used to produce these data are found within the manuscript methods section.

## Description of the Data and file structure

#### Site level files:

For each of the 17 study sites, there are 8 CABLE-POP simulation output files (.nc), 6 CABLE-POP settings files (.nml), and 2 parameter files (.csv and .txt).

##### Simulation output:

Simulation output is found within the *site\_level\_simulations.zip* folder. Within the zip file, there are two folders - one for the *acclim\_on* simulations and one for the *acclim\_off* simulations under which there are folders for each site that contain four simulation output files named as follows:

* plume\_out\_cable\_1850\_1900.nc
* plume\_out\_cable\_1901\_2005.nc
* plume\_out\_cable\_2006\_2099\_8p5\_varying.nc
* plume\_out\_cable\_2006\_2099\_8p5\_static2005.nc

These are self-documenting netcdf files. A list of all variables including their units can be found in the attached document (*CABLE-POP\_output\_variable\_list.docx*).

##### Settings:

CABLE-POP namelist files are found within the *site\_nml\_files.zip* folder. Within this zip file there are 6 namelist files for each site for the varying CO<sub>2</sub> simulations with files named as follows:

* cable\_1850-1900\_sitename\_acclim\_off.nml
* cable\_1901\_2005\_sitename\_acclim\_off.nml
* cable\_2006\_2099\_sitename\_acclim\_off.nml
* cable\_1850-1900\_sitename\_acclim\_on.nml
* cable\_1901\_2005\_sitename\_acclim\_on.nml
* cable\_2006\_2099\_sitename\_acclim\_on.nml

Namelist files are used by CABLE-POP to provide important information about the run settingsand are needed to reproduce simulations. The files can be opened in any text editor and are self-documented.

##### Parameters:

Parameter files are found within the *site\_params.zip* folder. Within the zip file, there are two files for each site containing all parameters for the 17 plant functional types (pft) used by CABLE-POP. The relevant pft's for this study are "2 forest evergreen\_broadleaf"; "6 grass C3 grassland" and "7 grass C4 grassland". Parameter names and units are listed within each of these file. These files are named and described as follows:

* veg\_params\_sitename.txt [contains the vegetation parameters (\~80). Parameters are listed in repeating blocks with a heading for the pft that begins with a number and then the pft name. Parameter values are listed to the left and parameter names listed to the right - the parameter values and names are listed in corresponding order.]
* pftlookup\_sitename.csv [contains additional parameters, sectioned by parameter type. In each section, parameter values are listed for each of the pft's in rows. The pft number is given in the leftmost column with the names detailed at the top of the file.]

#### Additional files:

Also included are 2 run scripts and 1 site list.

##### Run scripts:

* run\_cable-pop.sh [runs cable-pop future simulations]
* site\_wrapper\_future.bash [loops through sites to run run\_cable-pop.sh]

##### Site list:

* OzFLUX\_sitelist\_GT\_All.txt [contains site name, eddy covariance data start year and end year, latitude, longitude, canopy height (m), eddy covariance tower height (m), reference height (m), vegetation description, NVIS5 group reference number, forest fraction, grass fraction and C4 grass fraction for each of the study sites]
* NVIS5 group reference number vegetation types are available from the Australian Government [NVIS v5.0 Major Vegetation Groups](https://www.dcceew.gov.au/sites/default/files/env/pages/ba1d4b30-d46f-42f7-bec2-fac391f26072/files/mvsg5-numeric-order.pdf).

## Sharing/access Information

The data is not available elsewhere publicly.

Site list, parameter files, and run\_cable\_pop.sh are derived from the CABLE-POP community.