# Stabilizing selection on a plumage-based foraging adaptation: hooded warblers with average-sized white tail spots live longer

[https://doi.org/10.5061/dryad.n8pk0p32t](https://doi.org/10.5061/dryad.n8pk0p32t)

This archive contains all the data presented in both the published paper and the electronic supplemental material.

## Description of the data and file structure

Four separate data files in .csv format are included in this archive; missing values are indicated by "null":

**1\. FinalMaleFemaleDataset\.csv**
This file is the primary data file for analysis. I contains records for 625 individual hooded warblers stored in 17 columns, A–Q:

1. IDCode – a unique identifier, based on colour-band combinations, for each bird.
2. BandNum – the unique U.S. Fish and Wildlife Service band number.
3. Sex – F indicates female, M indicates male.
4. DateBand – Date the bird was initially banded or measured.
5. FirstYr – The first year the bird was present on the study area.
6. LastYr – The last year the bird was present on the study area.
7. YrPr – How many years the bird was present on the study area.
8. YrSurv – How many years the bird survived, calculated as LastYr–FirstYr
9. YoungFl – Total number of young fledged from the bird’s nests throughout its entire reproductive lifespan on the study area.
10. WingC – Wing chord (length) in mm.
11. TailL – Tail length (in mm)
12. R6White – Maximum linear extent of white (in mm) on rectrix 6
13. R5White – Maximum linear extent of white (in mm) on rectrix 5
14. R4White – Maximum linear extent of white (in mm) on rectrix 4
15. R3White – Maximum linear extent of white (in mm) on rectrix 3
16. Mass – Body mass (in g)
17. TWIndex – Tail white index, calculated as the (R6White + R5White + R4White)/ (3 \* TailL).

**2\. AnnualSurvivalData\.csv**
This file was used to examine annual survival (see electronic supplementary material, figure S7). It contains records for 1161 individual bird-years, stored in 19 columns, A–S. Most of the column names are identical to those in the previous file (FinalMaleFemaleDataset.csv), but 4 are new:

9. Year – Year of potential survival for this particular bird.
10. Present – Y simply indicates that the bird was present on the study area this particular year.
11. Sur – 1 indicates this bird was known to have survived to the following year, while 0 indicates that it was not known to have survived to the following year.
12. Age – Best estimate of the bird’s age this particular year.

**3\. RepeatabilityData\.csv**
This file was used to estimate the repeatability (intraclass correlation coefficient) of the tail white index, TWIndex (see electronic supplementary material, figure S1). It contains 111 capture records for 52 individuals whose tails were measured in two or more years separated by the annual molt. Most of the columns (A–M) are identical or similar to those used in the previous two files, but two are new:

1. Age – Age at the time of capture; SY indicates a bird in its second year of life, ASY indicates an older bird (after second year of life).
2. N – Number of separate capture records available for this bird.

**4\. HeritabilityData\.csv**
This file was used to estimate the heritability of the tail white index, TWIndex (see electronic supplementary material, figure S2). It contains 7 records of tail measurements of birds for whom tail measurements are also available for their putative parents. The columns are:

1. OffspringID – The unique ID code of the offspring.
2. Sex – Offspring sex.
3. FatherTWI – Tail white index of the putative father.
4. MotherTWI – Tail white index of the putative mother.
5. MeanParTWI – Mean tail white index of both putative parents.
6. OffspringTWI – The tail white index of the offspring.