# Introduction

The data set contains received signal strength (RSS) measurements made with Bluetooth Low Energy (BLE) technology, which can be used for outdoor fingerprinting based localization applications, as presented in publicitation "LOG-a-TEC Testbed Outdoor Localization Usign BLE Beacons" (https://ieeexplore.ieee.org/document/9900607).

# Measurement Setup

The measurements were created with WL1837MOD radio connected to a [in-house embedded device](https://log-a-tec.eu/hw-lgtc.html). The data set was collected with 40 nodes of the [LOG-a-TEC testbed](https://log-a-tec.eu) positioned at the campus of the Jožef Stefan Institute, Ljubljana. The experimentation area is composed of 5 x 26 positions separated by 1.2 m covering 150 square meters. On each position a mobile phone was broadcasting BLE advertising beacons with power of -2 dBm in interval of 100 ms. Surrounding testbed nodes were collecting the beacons for approximately a minute for each position.

# Data set

Measurements are stored in JSON format where each object contains rss measurement (in dBm) with corresponding timestamp (in seconds). The folder contains two JSON files:

* spring_data.json - measurements made in May 2022,
* winter_data.json - smaller measurements made in December 2021. This data set contains only the measurements from the middle row of the campus park.

Note, that the device numbers go from 51~71 (excluding 68) and from 81~86 (excluding 85). 


# Data Format

{
  "(<row>, <column>)": 
  {
    "<device_number>": [
      {"rss": <RSS_value>, "timestamp": <timestamp_sec>}, {"rss": <RSS_value>, "timestamp": <timestamp_sec>}, {"rss": <RSS_value>, "timestamp": <timestamp_sec>}, ...
    ],

    "<device_number>": [
      {"rss": <RSS_value>, "timestamp": <timestamp_sec>}, {"rss": <RSS_value>, "timestamp": <timestamp_sec>}, {"rss": <RSS_value>, "timestamp": <timestamp_sec>}, ...
    ],
  .
  .
  .
  },
  "(<row>, <column>)": 
  {
    "<device_number>": [
      {"rss": <RSS_value>, "timestamp": <timestamp_sec>}, {"rss": <RSS_value>, "timestamp": <timestamp_sec>}, {"rss": <RSS_value>, "timestamp": <timestamp_sec>}, ...
    ],

    "<device_number>": [
      {"rss": <RSS_value>, "timestamp": <timestamp_sec>}, {"rss": <RSS_value>, "timestamp": <timestamp_sec>}, {"rss": <RSS_value>, "timestamp": <timestamp_sec>}, ...
    ],
  }
}



