# Auxiliary files for modelling invasion resistance in multispecies communities

[https://doi.org/10.5061/dryad.0k6djhb60](https://doi.org/10.5061/dryad.0k6djhb60)

This is a set of auxiliary files and simulation codes for a model of invasion resistance in a multispecies community. The model is based on an N-dimensional replicator equation, whose coefficients are pairwise invasion fitnesses between system members. This equation can be studied in its own right or derived naturally from a co-colonization SIS model with multiple interacting strains, though a slow-fast dynamics approach.

**For more technical details on the derivation of the replicator system see:**

* Madec, S., Gjini, E. Predicting N-Strain Coexistence from Co-colonization Interactions: Epidemiology Meets Ecology and the Replicator Equation. *Bull Math Biol* 82, 142 (2020) [https://doi.org/10.1007/s11538-020-00816-w](https://doi.org/10.1007/s11538-020-00816-w)
* Gjini, Erida, and Sten Madec. "The ratio of single to co‐colonization is key to complexity in interacting systems with multiple strains." *Ecology and Evolution* 11.13 (2021): 8456-8474. [https://doi.org/10.1002/ece3.7259](https://doi.org/10.1002/ece3.7259)
* Le, Thi Minh Thao, Erida Gjini, and Sten Madec. "Quasi-neutral dynamics in a coinfection system with N strains and asymmetries along multiple traits." *Journal of Mathematical Biology* 87.3 (2023): 48. [https://doi.org/10.1007/s00285-023-01977-7](https://doi.org/10.1007/s00285-023-01977-7)

## Description of the data and file structure

**In Dryad** we provide some examples (.csv files) for the pairwise invasion fitness matrix Λ among 10 species (N=10), illustrating one of the canonical structures delineated in the paper. These structures are the following:
i) symmetric Λ
ii) invader-driven Λ (equal columns)
iii) resident-driven Λ (equal rows)
iv) anti-symmetric Λ
v) almost anti-symmetric Λ
vi) random Λ

Each of these structures leads to qualitatively different dynamics among the N species and consequently to different systemic invasion resistance overall. For example, the symmetric and invader-driven structure of the Λ matrix more likely lead to multi-species stable steady-state coexistence and an asymptotic *positive* system invasion resistance (Q&gt;0), whereas the resident-driven structure leads more to competitive exclusion and a system with invasion resistance *tending to zero* (Q=0). The anti-symmetric Λ structure leads to complex multi-species coexistence of oscillatory nature, where throughout the dynamics, the system's invasion is *always exactly zero* (Q=0). Notice that each Λ matrix can be scaled by the same multiplicative factor and while the speed of dynamics may change, the quality of the dynamics will not.
We also provide Python notebooks and two Matlab files based on ordinary-differential-equation system simulation (*N-dimensional replicator system*), under specific parameter structures (*pairwise invasion matrix*) for many random realizations of those structures.

**In the linked Zenodo platform** (software), we provide Python and MATLAB simulation codes related to the model and concrete figures in the paper. Please go to Zenodo to download these associated codes and cite them accordingly.

## Sharing/Access information

Links to other publicly accessible locations of the Python codes:

* https://github.com/stenmadec/Replicator-equation-for-co-colonization/tree/main

## Code/Software

In Zenodo (software link: [https://doi.org/10.5281/zenodo.10049009](https://doi.org/10.5281/zenodo.10049009)), we provide code files for **studying and simulating invasion resistance** in different replicator systems characterized by a particular pairwise invasion matrix structure (Λ) between N species: *i) symmetric, ii) invader-driven, iii) resident-driven, iv) anti-symmetric, v) almost anti-symmetric* and *vi) random*. Each of these matrix structures leads to qualitatively different dynamics among the N species, and consequently to different systemic invasion resistance overall. The codes also illustrate examples and particular investigations of how a resident system's invasion resistance determines invasion success of an outsider species. These files have been used for generating figures 2-6 of our paper (2023) *"Towards a mathematical understanding of invasion resistance in multispecies communities"*, by E. Gjini and S. Madec.