function Y = runDTSys(A,B,C,D,U,T)
%Simulates the discrete time system given by 
%x[t+1] = Ax[t] + Bu[t]
%y[t]  = Cx[t] + Du[t]
%for T time steps and input U.

% This file is part of Code and Data for the numerical experiments in 
% "Frequency-Based Reduced Models from Purely Time-Domain Data via Data Informativity"
% Copyright (C) 2023 Michael S. Ackermann
% All rights reserved.
% License: BSD 2-Clause License (see COPYING)
n = length(A);
t_len = length(T);

x = zeros(n,t_len+1);
Y = zeros(t_len,1);
for t = 1:t_len
    x(:,t+1) = A*x(:,t) + B*U(t);
    Y(t) = C*x(:,t) + D*U(t);
end