function [Q,R] = orthogonalize_Wz(W,z)
% Computes QR decomposition of [W z] where W is already orthogonal
% Computed via Graham Schmidt with reorthogonalization
%%%%% INPUTS %%%%%%
% W: tall and skinny orthogonal matrix
% z: vector to append to W
%%%%% OUTPUTS %%%%%%
% Q, R:  matrices such that QR = [W z]

% This file is part of Code and Data for the numerical experiments in 
% "Frequency-Based Reduced Models from Purely Time-Domain Data via Data Informativity"
% Copyright (C) 2023 Michael S. Ackermann
% All rights reserved.
% License: BSD 2-Clause License (see COPYING)
[~,n] = size(W);

u = W'*z;
v = z - (W*u);
c = W'*v;
v = v-W*c;
u = u + c;
rho = norm(v);

R = sparse([eye(n), u;zeros(1,n), rho]);
Q = [W v/rho];