function [unique_cond,exist_cond] = check_rank_conds(U,z,b,tau1,tau2)
% Checks if the system 
%         [U z]x = b
% has a solution (exist_cond) and if the last component of that solution is
% unique (unique_cond)

% Checks up to the tolerances Tau1 and Tau2 (see subsection 3.1.2)

%%%%% INPUTS %%%%%%
% U:  an orthonormal matrix
% z:  appended to U 
% b:  the right hand side
% tau1: tolerance on uniqueness condition
% tau2: tolerance on the existence condition

%%%%% OUTPUTS %%%%%%
% exist_cond: true if the linear system has a solution up to tolerance tau2 
% unique_cond: true if linear system has a solution up to tolerance tau1

% This file is part of Code and Data for the numerical experiments in 
% "Frequency-Based Reduced Models from Purely Time-Domain Data via Data Informativity"
% Copyright (C) 2023 Michael S. Ackermann
% All rights reserved.
% License: BSD 2-Clause License (see COPYING)


v = z-(U*(U'*z));
b_perp = b-(U*(U'*b));
%% Uniqueness condition
unique_cond = norm(v) >= (tau1*norm(z));
%% existence condition
exist_cond = norm(b_perp - ((v*(v'*b_perp))/(norm(v)^2))) <= (tau2*norm(b));

