function RHS = Make_RHS(k,Mj,n,s)
% Makes the right hand side of the linear system used to recover derivative
% data from time domain data

%%%%% INPUTS %%%%%%
% s: point in C to calculate k-th derivative at
% k:  order of derivative
% Mj:  vector of transfer function derivative values of order 0 to k-1
%    (i.e., contains all lower order derivatives at s)
% n:  order of system

%%%%%% OUTPUTS %%%%%%%
% RHS: right hand side of the linear system to solve for k-th derivative of
% a dynamical system at s

% This file is part of Code and Data for the numerical experiments in 
% "Frequency-Based Reduced Models from Purely Time-Domain Data via Data Informativity"
% Copyright (C) 2023 Michael S. Ackermann
% All rights reserved.
% License: BSD 2-Clause License (see COPYING)


%calulate the top half of RHS
gamma_sig_1 = calc_gamma(s,n,k);

%calculate bottom half of RHS
gamma_sig_2 = zeros(n+1,1);
for j = 0:k-1
    gamma_sig_2 = gamma_sig_2...
        + nchoosek(k,j)*Mj(j+1)*calc_gamma(s,n,k-j);
end

RHS = [gamma_sig_1;gamma_sig_2];