function n = MOESP(U,Y)
% Function to find an approximation to the system order.
%%%%%% INPUTS %%%%%%
% U,Y are data vectors from time domain simulation of system
%%%%%% OUTPUTS %%%%%
%n is (numerical) order of system.

% Reference:
% M. Verhaegen and P. Dewilde, Subspace model identification Part 1. The output-error state-
% space model identification class of algorithms, International Journal of Control, 56 (1991), pp. 1187–1210, https://doi.org/10.1080/00207179208934363.


% This file is part of Code and Data for the numerical experiments in 
% "Frequency-Based Reduced Models from Purely Time-Domain Data via Data Informativity"
% Copyright (C) 2023 Michael S. Ackermann
% All rights reserved.
% License: BSD 2-Clause License (see COPYING)

n_surr = floor(length(U)/3)-1; 

Hu = HankMat(U,n_surr);
Hy = HankMat(Y,n_surr);
[M,~] = size(Hu);

[~, R] = qr([Hu.' Hy.'],0);
R22 = R(end-M+1:end,end-M+1:end);
n = rank(R22);

