function Hx = HankMat(x,n)
% constructs Hankle Matrix of depth n for the data x

% This file is part of Code and Data for the numerical experiments in 
% "Frequency-Based Reduced Models from Purely Time-Domain Data via Data Informativity"
% Copyright (C) 2023 Michael S. Ackermann
% All rights reserved.
% License: BSD 2-Clause License (see COPYING)

T = length(x)-1;

Hx = NaN(n+1,T-n+1);
for j = 0:T-n
    for i = 0:n
        Hx(i+1,j+1) = x(i+j+1);
    end
end