Code and Data for the numerical experiments in "Frequency-Based Reduced 
    Models from Purely Time-Domain Data via Data Informativity"
===========================================================================

This archive contains the companion codes for the paper:

    M. S. Ackermann, S. Gugercin; Frequency-Based Reduced 
    Models from Purely Time-Domain Data via Data Informativity,

which implement the reported numerical experiments.


## CODE

### Dependencies and installation

The computations were originally performed in MATLAB 23.2.0.2365128 (R2023b)
on a 2023 MacBook Pro equipped with 16 GB RAM and
Apple M2 Pro chip running macOS Ventura 13.4.1

The following MatLab toolboxes are required to run the experiments:
*Control System Toolbox
*Parallel Computing Toolbox
*Signal Processing Toolbox

Control System Toolbox is used to compute frequency responses of identified reduced order models (in experiments for Section 4).
Parallel Computing Toolbox is used to reduce computation time.  To remove this dependency, change all `parfor` loops to `for` loops.
Signal Processing Toolbox is used to generate a Sawtooth input for one example not included in the text.

Additionally, the following software packages are used:

* vectfit3_discrete.m, modified from vectfit3.m written by Bjorn Gustavsen [https://www.sintef.no/en/software/vector-fitting/downloads/#menu]; It is located in the 'software' directory.

To properly set the MATLAB search path necessary for the
experiments, run the `setup.m` script before the experiments.


### Content and structure

The archive contains the following subdirectories:

* `functions/helpers`: contains convenience scripts.
* `data`: contains all data for the experiments.
* `software`: location for the reduced order modeling codes
* `functions`: contains the main algorithm from the text
* `SECTION 3`: contains the scripts to reproduce the experiments performed in Section 3 of the text
* `SECTION 4`: contains the scripts to reproduce the experiments performed in Section 4 of the text

The scripts in SECTION 3 are named according to the plot they generate in the text.
The scripts in SECTION 4 are named `RecoverFreqData_*` if they are used only to recover frequency data from time domain data
The scripts in SECTION 4 are named `CompareROMs_*` if they are used to produce reduced order models from time-domain data

## AUTHOR

Michael S. Ackermann
- affiliation: Virginia Tech, Blacksburg, VA (USA)
- email: amike98@vt.edu
- orcid: [0000-0003-3581-6299](https://orcid.org/0000-0003-3581-6299)


###########################################################################################
## LICENSE

Copyright (C) 2023 Michael S. Ackermann

The software is licensed under the BSD-2-Clause License.
See [COPYING](COPYING) for a copy of the license.

The following exception holds:

The folder *software* and its contents. The routines contained therein may
have different license models. Please check the corresponding *README* file or
the license header for further information.


## CITATION

### DOI

The DOI for version 1.0 of this archive is
[10.5281/zenodo.10076325](https://doi.org/10.5281/zenodo.10076325)


### Cite as

Ackermann, M. S. (2023). Code and Data for the numerical experiments in "Frequency-Based Reduced Models from Purely Time-Domain Data via Data Informativity" (1.0). Zenodo. https://doi.org/10.5281/zenodo.10076325


### BibTeX

    @MISC{supAck23,
      author =       {Ackermann, M.~S.},
      title  =       {Code and Data for the numerical experiments in ``{F}requency-Based Reduced Models
      			 from Purely Time-Domain Data via Data Informativity'' (version 1.0)},
      month  =       nov,
      year   =       {2023},
      doi    =       {10.5281/zenodo.10076325}
    }
