% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transplant_w_niche_occupation.R
\name{transplant_w_niche_occupation}
\alias{transplant_w_niche_occupation}
\title{Simulate community transplantation with recipient antagonism}
\usage{
transplant_w_niche_occupation(
  recipient,
  donor,
  n.niches = 1,
  niche.shape = "normal",
  niche.size.resident = 3,
  niche.size.donor = 1,
  abundance.threshold = 0.05,
  process.type = "preemption"
)
}
\arguments{
\item{recipient}{Numeric matrix. The starting community matrix that represents the resident community in N samples.}

\item{donor}{Numeric matrix. The donor community matrix that represents the donor community. Typically, the result of build_donor_community().}

\item{n.niches}{Positive whole numeric vector of length 1. Number of rounds of niche selection to perform.}

\item{niche.shape}{Character vector of length 1. Currently only "normal" is supported. The niche distribution shape to draw from for niche occupation values.}

\item{niche.size.resident}{Positive whole numeric vector of length 1. The number of taxa in resident community that occupy the niche. Default = 3.}

\item{niche.size.donor}{Positive whole numeric vector of length 1. The number of taxa in resident community that occupy the niche. Default = 1.}

\item{abundance.threshold}{Positive numeric vector of length 1, between 0 and 1. The relative abundance threshold for resident taxa in niche to trigger effect. This will be mean of distribution...if niche.size.resident > 1, thresholds for additional taxa will be based on the distribution of niche.shape. Default = 0.05.}

\item{process.type}{Character vector of length 1. Must currently be in c("preemption","permission"). Under "preemption", when the niche occupancy threshold is reached in a given sample, the resident taxon will begin to decrease the abundance of the donor taxon. Under "permission", when that threshold is reached, the resident taxon will enable the presence of the donor taxon (where the threshold is not reached, the donor taxon abundance will drop to 0). Default = "preemption".}
}
\value{
Taxon abundance matrix with samples as rows and taxa as columns. class='matrix'.
}
\description{
Manipulates a community matrix with samples as rows and taxa as columns. Donor taxa abundances will be increased or decreased correspondingly with the niche occupancy of taxa in the recipient community.
}
\examples{
recipient <- build_even_community(n.taxa = 100,n.samples = 44,n.reads = 3000, taxa.sd = 30)
donor <- build_donor_community(resident.comm = even,n.transplant.taxa = 10,overlap = .3)
transplant_w_niche_occupation(recipient, donor, n.niches = 1, niche.shape = 'normal',
niche.size.resident = 3, niche.size.donor = 1, abundance.threshold = .05,
process.type = "preemption")

}
