% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transplant_w_facilitation.R
\name{transplant_w_facilitation}
\alias{transplant_w_facilitation}
\title{Simulate community transplantation with recipient facilitation}
\usage{
transplant_w_facilitation(
  recipient,
  donor,
  facil.ubiq = 0.5,
  facil.strength = 1,
  facil.abundant = TRUE
)
}
\arguments{
\item{recipient}{Numeric matrix. The starting community matrix that represents the resident community in N samples.}

\item{donor}{Numeric matrix. The donor community matrix that represents the donor community. Typically, the result of build_donor_community().}

\item{facil.ubiq}{Positive numeric vector of length 1, between 0 and 1. The proportion of your donor taxa that have facilitative taxa in the recipient community.}

\item{facil.strength}{Positive numeric vector of length 1, between 0 and 1. Determines the scale of facilitation. i.e., how much increase to do to donor taxa, proportionate to facilitator relative abundance.}

\item{facil.abundant}{Logical. If TRUE, recipient facilitators will be selected from the most abundant taxa. If FALSE, they will be selected randomly from all taxa.}
}
\value{
Taxon abundance matrix with samples as rows and taxa as columns. class='matrix'.
}
\description{
Manipulates a community matrix with samples as rows and taxa as columns. Donor taxa will be increased correspondingly with the abundance of random facilitative taxa present in the recipient community.
}
\examples{
recipient <- build_even_community(n.taxa = 100,n.samples = 44,n.reads = 3000, taxa.sd = 30)
donor <- build_donor_community(resident.comm = even,n.transplant.taxa = 10,overlap = .3)
transplant_w_facilitation(recipient, donor, facil.ubiq = .5, facil.strength = .5)

}
