% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transplant_w_antagonism.R
\name{transplant_w_antagonism}
\alias{transplant_w_antagonism}
\title{Simulate community transplantation with recipient antagonism}
\usage{
transplant_w_antagonism(
  recipient,
  donor,
  antag.ubiq = 0.5,
  antag.strength = 0.1,
  antag.abundant = TRUE
)
}
\arguments{
\item{recipient}{Numeric matrix. The starting community matrix that represents the resident community in N samples.}

\item{donor}{Numeric matrix. The donor community matrix that represents the donor community. Typically, the result of build_donor_community().}

\item{antag.ubiq}{Positive numeric vector of length 1, between 0 and 1. The proportion of your donor taxa that have antagonistic taxa in the recipient community.}

\item{antag.strength}{Positive numeric vector of length 1, between 0 and 1. Determines the scale of antagonism. i.e., how much reduction to do to donor taxa, proportionate to antagonist relative abundance.}

\item{antag.abundant}{Logical. If TRUE, recipient antagonists will be selected from the most abundant taxa. If FALSE, they will be selected randomly from all taxa.}
}
\value{
Taxon abundance matrix with samples as rows and taxa as columns. class='matrix'.
}
\description{
Manipulates a community matrix with samples as rows and taxa as columns. Donor taxa will be reduced correspondingly with the abundance of random antagonists present in the recipient community.
}
\examples{
recipient <- build_even_community(n.taxa = 100,n.samples = 44,n.reads = 3000, taxa.sd = 30)
donor <- build_donor_community(resident.comm = even,n.transplant.taxa = 10,overlap = .3)
transplant_w_antagonism(recipient, donor, antag.ubiq = .5, antag.strength = .5)

}
