% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_taxa_abundances.R
\name{link_taxa_abundances}
\alias{link_taxa_abundances}
\title{Simulate co-occurrence relationships between taxa}
\usage{
link_taxa_abundances(
  dat,
  n.taxa = 2,
  relationship = "positive",
  link.scale = 0.2,
  n.links = round(ncol(dat) * 0.2)/2
)
}
\arguments{
\item{dat}{Numeric matrix. The starting community matrix that will be edited.}

\item{n.taxa}{Positive numeric vector of length 1. The number of taxa to link together. If n.taxa=1, nothing happens. If n.taxa=2, two taxa will be linked. If n.taxa > 2, a hub network will be created (you must select relationship='hub'). Default = 2.}

\item{relationship}{Character vector of length 1. Must be one of c("positive","negative","hub"). If "positive", then taxon 2 will be altered to increase proportionally with taxon 1. If "negative", the opposite will occurr. If "hub", approximately half of the taxa will have a positive and half a negative relationship with a random hub taxon. Default = "positive".}

\item{link.scale}{Numeric vector of length 1. how strong should the similarity function be. Multipliciative. 0=no change.}

\item{n.links}{Positive whole numeric vector of length 1. The number of taxa that will be linked with other taxa. Default = 20% of all samples.}
}
\value{
Taxon abundance matrix with samples as rows and taxa as columns. class='matrix'. Random taxon abundance values will be altered to simulate co-occurrence according to parameters selected.
}
\description{
Manipulates a community matrix with samples as rows and taxa as columns.
}
\examples{
comm <- build_even_community(n.taxa = 100,n.samples = 44,n.reads = 3000, taxa.sd = 30)
link_taxa_abundances(dat = comm,n.taxa = 10,relationship = "hub",link.scale = .5,n.links = 2)

}
