% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_sample_communities.R
\name{link_sample_communities}
\alias{link_sample_communities}
\title{Force increased similarity between random groups of samples in terms of taxa counts}
\usage{
link_sample_communities(dat, n.links = 1, group.size = 3, link.strength = 0.9)
}
\arguments{
\item{dat}{Numeric matrix. The starting community matrix that will be edited.}

\item{n.links}{Positive numeric vector of length 1. The number of groupings to force. Must be >= 1 and < sample.number/group.size}

\item{group.size}{Positive numeric vector of length 1. Determines how many samples to make similar in each grouping. Must be >= 2 and <= sample.number/n.links}

\item{link.strength}{Numeric vector of length 1. how strong should the similarity function be. 0=no change; 1=make identical.}
}
\value{
Taxon abundance matrix with samples as rows and taxa as columns. class='matrix'. Random sample abundance values will be altered to show increased similarity according to parameters selected.
}
\description{
Manipulates a community matrix with samples as rows and taxa as columns.
}
\examples{
comm <- build_even_community(n.taxa = 100,n.samples = 44,n.reads = 3000, taxa.sd = 30)
link_sample_communities(comm, n.links = 3, group.size = 4, link.strength = 0.25)

}
