% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_taxa_along_gradient.R
\name{filter_taxa_along_gradient}
\alias{filter_taxa_along_gradient}
\title{Simulates abiotic filtration of taxa along a gradient.}
\usage{
filter_taxa_along_gradient(
  dat,
  prop = 0.1,
  gradient.min = 0,
  gradient.max = 1,
  gradient.strength = 1,
  groups = 1,
  association = "negative",
  transplant.only = FALSE,
  show.gradient = FALSE
)
}
\arguments{
\item{dat}{Numeric matrix. The starting community matrix that will be edited.}

\item{prop}{Positive numeric vector of length 1, between 0,1. The proportion of taxa affected by the abiotic gradient.}

\item{gradient.min}{Positive numeric vector of length 1 and >=0 and <=1. The minimum starting value of the abiotic gradient.}

\item{gradient.max}{Positive numeric vector of length 1 and >=0 and <=1. The minimum ending value of the abiotic gradient.}

\item{gradient.strength}{Positive numeric vector of length 1. A multiplier for abundance transformations along the gradient. Values between 0 and 1 will reduce the environmental effect.}

\item{groups}{Positive whole number vector of length 1. Indicates how many gradient simulations to divide samples into. If groups is not a factor of the number of samples in the matrix, the remaining samples will receive a partial gradient adjustment.}

\item{association}{Character vector of length 1. Must be either 'positive' or 'negative'. Partial matching not allowed. Determines whether the gradient increases or decreases taxa abundances. Default = 'negative'.}

\item{transplant.only}{Logical vector of length 1. If TRUE, the gradient will only affect new taxa that persisted after transplantation. This only makes sense if performing this function on a matrix that is the result of a previous transplantation step, such as a matrix provided by transplant_w_facilitation(). Default = FALSE.}

\item{show.gradient}{Logical vector of length 1. If TRUE, a simple plot of the gradient strength along samples in the matrix will be returned as a side effect.}
}
\value{
Taxon abundance matrix with samples as rows and taxa as columns. class='matrix'. Taxon abundance values will be reduced or increased along a gradient according to parameters selected.
}
\description{
Manipulates a community matrix with samples as rows and taxa as columns.
Simulates an environmental gradient and adjusts a proportion of taxon abundances along it.
Multiple groups can be provided so that the gradient is replicated, simulating experimental replication.
Where the gradient value is 0, no change is made to taxon abundances.
}
\examples{
comm <- build_even_community(n.taxa = 100,n.samples = 44,n.reads = 3000, taxa.sd = 30)
donor <- build_donor_community(resident.comm = comm, n.transplant.taxa = 30,overlap = .25)
transplanted <- transplant_w_niche_occupation(comm, donor, niche.size.donor = 2, niche.size.resident = 3, process.type = "permission")
filter_taxa_along_gradient(transplanted, prop=.5, groups=2, transplant.only=TRUE)

}
