% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decrease_abundances.R
\name{decrease_abundances}
\alias{decrease_abundances}
\title{Manipulates taxon or sample abundances in an arbitrary manner.}
\usage{
decrease_abundances(
  dat,
  prop = 0.1,
  reduction.scale = 0.9,
  transplant.only = FALSE,
  margin = "taxa"
)
}
\arguments{
\item{dat}{Numeric matrix. The starting community matrix that will be edited.}

\item{prop}{Positive numeric vector of length 1, between 0,1. The proportion of taxa affected by the arbitrary abundance changes.}

\item{reduction.scale}{Positive numeric vector of length 1 and >=0 and <=1. The proportionate amount to decrease a given taxon or sample.}

\item{transplant.only}{Logical vector of length 1. If TRUE, the gradient will only affect new taxa that persisted after transplantation. This only makes sense if performing this function on a matrix that is the result of a previous transplantation step, such as a matrix provided by transplant_w_facilitation(). If margin = "samples" then this is ignored. Default = FALSE.}

\item{margin}{Character vector of length 1. Must be either 'taxa' or 'samples'. Partial matching not allowed. Determines whether the gradient increases or decreases taxa abundances. Default = 'negative'.}
}
\value{
Taxon abundance matrix with samples as rows and taxa as columns. class='matrix'. Random taxon or random sample abundance values will be decreased according to parameters selected.
}
\description{
Manipulates a community matrix with samples as rows and taxa as columns.
}
\examples{
comm <- build_even_community(n.taxa = 100,n.samples = 44,n.reads = 3000, taxa.sd = 30)
decrease_abundance(comm,prop = .5,reduction.scale = .95,margin = "samples")

}
