% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_donor_community.R
\name{build_donor_community}
\alias{build_donor_community}
\title{Build a community matrix to simulate community transplantation}
\usage{
build_donor_community(resident.comm, n.transplant.taxa, overlap = 0)
}
\arguments{
\item{resident.comm}{Numeric matrix. The starting community matrix that this one will be based on. Typically, the result of build_even_community() or a similar starting community.}

\item{n.transplant.taxa}{Positive numeric vector of length 1. The number of taxa in the donor community. This represents the microbiome community that will be transplanted into the resident community.}

\item{taxa.overlap}{Positive numeric vector of length 1 and >=0 and <=1. The proportion (between 0,1) of donor taxa that will also be present in the recipient community.}
}
\value{
Taxon abundance matrix with samples as rows and taxa as columns. class='matrix'. Non-overlapping taxa will have names beginning with "newtaxon_".
}
\description{
Builds a community matrix with samples as rows and taxa as columns.
The number of samples will match the starting (resident) community provided.
Taxon abundances will be on a similar scale to the provided resident community.
}
\examples{
comm <- build_even_community(n.taxa = 100,n.samples = 44,n.reads = 3000, taxa.sd = 30)
donor <- build_donor_community(resident.comm = comm, n.transplant.taxa = 30,overlap = .75)

}
