

#This scripts calls a validation function to check cluster assignments by random forest models trained on DE genes

## ----receive input from nextflow----------------------------------------------
args <- commandArgs(TRUE)
path<-args[1]
file<-args[2]
dendrogram<-args[3]

print(path)
set.seed(123)
timepoints<-substr(file,12,nchar(file)-6)




## ---- Load standard package list ----------------------------------------------
source(paste0(path,'/bin/auxiliary/DirectoryChecker.R'))
source(paste0(path,'/bin/auxiliary/PackageLoader.R'))
source(paste0(path,'/bin/auxiliary/SetPlottingParameters.R'))

#Load the validation and cell scoring function
source(paste0(path,'/bin/auxiliary/ScoreMembership.R'))


#check ram
RAM<-get_ram()
print(paste(RAM,'RAM passed to Rscript'))

ncor=detectCores()-1
print(paste(ncor,'cores detected'))
plan("multiprocess", workers = ncor -1)
options(future.globals.minSize = 10000 * 1024^2)



## ---- File setup ----------------------------------------------

#load data files
load(file)

#load markers extracted form MET data
load(dendrogram)


integrated[['iterative_clust']] <- NA
integrated[['iterative_clust']][rownames(dendrogram[["Cluster Labels"]]),] <- as.numeric(dendrogram[["Cluster Labels"]][,1])

#membershipScore<-ScoreMembership(integrated_clean,'iterative_clust')

#Idents(integrated_clean)<-'iterative_clust'



#Alternate setting
membershipScore<-ScoreMembership(integrated,'iterative_clust',ntree=1000,nGene=20,nIteration=100,logFC.thresh = log(1.5))




 
integrated[['cluster_label']]<-integrated[['putative_identity']]
integrated[['cluster_label']][WhichCells(integrated,expression=putative_identity!='Meis2'),] <- membershipScore[[1]]$classification


integrated[['certainty_score']]<-'Not Assessed'
integrated[['certainty_score']][WhichCells(integrated,expression=putative_identity!='Meis2'),]<-as.character(membershipScore[[1]]$certainty)

integrated[['cluster_label']][WhichCells(integrated,expression=certainty_score=='Failure'),]<-'FailedClassification'

#pass to next process
save(integrated,file='integrated_validated.Rdata')







