
#This script loads in the required data to produce figures, and calls figure plotting scripts

set.seed(123)

## ----receive input from nextflow----------------------------------------------
#Get parameters
args <- commandArgs(TRUE)
path<-args[1]
file<-args[2]
MET<-args[3]
modules<-args[4]
spatial<-args[5]
Allen10x<-args[6]
Mayer10x <- args[7]
print(path)


timepoints<-substr(file,12,nchar(file)-17)
figurePath<-paste0(path,'/output/figures') 

if(!dir.exists(figurePath)){
  dir.create(figurePath)
}



## ----load---------------------------------------------

#Load standard package list, etc.
source(paste0(path,'/bin/auxiliary/PackageLoader.R'))
source(paste0(path,'/bin/auxiliary/DirectoryChecker.R'))
source(paste0(path,'/bin/auxiliary/SetPlottingParameters.R'))


#check ram
RAM<-get_ram()
print(paste(RAM,'RAM passed to Rscript'))

ncor=detectCores()
print(paste(ncor,'cores detected'))
plan("multiprocess", workers = ncor )
options(future.globals.maxSize = 10000 * 1024^2)


#load data
load(file)
load(MET)
load(modules)
load(Allen10x)
load(Mayer10x)

x <- load(spatial)
spatialP5SST <- get(x[1])
spatialP5SSTfull <- get(x[2])
spatialP5full <- get(x[3])
spatialPlots <- get(x[4])

#genes for heatmap(s)
heatmapGenes<-read.csv(paste0(path,'/input/supplementary/Fig1DEHeatmapGenes.csv'),header=T)
heatmapGenes <- as.character(heatmapGenes[,1])
pseudoGenes<-read.csv(paste0(path,'/input/supplementary/Fig3PseudotimeHeatmapGenes.csv'),header=T)
pseudoGenes <- as.character(pseudoGenes[,1])
#integrated<-subset(integrated,cells=WhichCells(integrated,expression=major_cluster_label!='FailedClassification'))
integratedSubset<-subset(integrated,cells=WhichCells(integrated,expression=major_cluster_label!='FailedClassification' & major_cluster_label != 'Stressed' & major_cluster_label != 'Meis2'))
integrated_clean<-integratedSubset


#load markers
canonmarkers<-read.csv(paste0(path,'/input/supplementary/CanonicalMarkers.csv'))
canonmarkers[,1] <- toupper(canonmarkers[,1])
markers<-list()
markers[['Martinotti']]<-canonmarkers[grep('^Martinotti',canonmarkers[,2]),1]
markers[['Non-Martinotti']]<-canonmarkers[grep('Non-Martinotti',canonmarkers[,2]),1]
markers[['LRP']]<-canonmarkers[grep('projecting',canonmarkers[,2]),1]
markers[['Stressed']]<-canonmarkers[grep('Stress',canonmarkers[,2]),1]


#getting the colours for clusters is fiddly, we'll do it here

# #sub-cluster colours
# colSet<-customCol
# names(colSet)<-cut(1:length(colSet),length(sort(unique(integrated$major_cluster_label))), labels=sort(unique(integrated$major_cluster_label)))
# 
# 
# cols<-c()
# for(group in unique(integrated$major_cluster_label)){
#   types<-sort(unique(integrated$cluster_label[grep(paste0("^",group),integrated$cluster_label)]))
#   c<-colorRampPalette(colSet[names(colSet)==group])(length(types))
#   names(c)<-types
#   cols<-c(cols,c)
# }
# 
cols <- colorRampPalette(customCol)(length(unique(integrated$cluster_label)))
names(cols)<-mixedsort(unique(integrated$cluster_label))

# cols<-customCol
# names(cols)<-sort(unique(integrated$cluster_label))
SubClusterCols<-cols



#If we're looking at E16 spatial data, then don't plot
spatialTime <- unique(spatialP5SST$timepoint)

if(spatialTime == 'P5'){
  
  
  #--- Figure 1 - Overview ----
  source(paste0(path,'/bin/auxiliary/PlotFigure1.R'))
  
  
  #---- Figure 2 Classify Mayer et al -------------
  source(paste0(path,'/bin/auxiliary/PlotFigure2.R'))
  
  #---- Figure 3 Metaneighbour -------------
  source(paste0(path,'/bin/auxiliary/PlotFigure3.R'))
  
  
  #---- Figure 4 Pseudotime ---------------
  source(paste0(path,'/bin/auxiliary/PlotFigure4.R'))
  
  
  #---- Figure 5 Spatial ----
  source(paste0(path,'/bin/auxiliary/PlotFigure5.R'))
  
  
  #---- Supplementary 1 - Flowchart ----
  
  #Made in Adobe Illustrator, no R script needed
  
  #---- Supplementary 2  - QC metrics ----
  source(paste0(path,'/bin/auxiliary/PlotFigureS2.R'))
  
  
  #---- Supplementary 3  - Integrated Data ----
  source(paste0(path,'/bin/auxiliary/PlotFigureS3.R'))
  
  
  #---- Supplementary 4  - Stressed Identity ----
  source(paste0(path,'/bin/auxiliary/PlotFigureS4.R'))

}


