#This script will load any/all packages required throughout the pipeline. 
#Not every package is used in every process, but for simplicity they are all loaded together

#This is needed to stop some packages complaining
Sys.setenv(R_REMOTES_NO_ERRORS_FROM_WARNINGS="true")
options(needs.promptUser = FALSE)


#---------------------------------
if (!require(devtools)){
  install.packages('devtools',repos='http://cran.us.r-project.org')
}
library(devtools)


#---------------------------------
if (!requireNamespace("BiocManager", quietly = TRUE)){
  install.packages("BiocManager",repos='http://cran.us.r-project.org')
}
library(BiocManager)


#---------------------------------
if (!require(MetaNeighbor)){
  BiocManager::install("MetaNeighbor",ask=F)
}
library(MetaNeighbor)


#---------------------------------
if (!require(SingleCellExperiment)){
  BiocManager::install("SingleCellExperiment")
}
library(SingleCellExperiment)



#--------------------------------- memory and computing
if (!require(parallel)){
  install.packages('parallel',repos='http://cran.us.r-project.org')
}
library(parallel)


#---------------------------------
if (!require(future)){
  install.packages('future',repos='http://cran.us.r-project.org')
}
library(future)


#---------------------------------
if (!require(benchmarkme)){
  install.packages('benchmarkme',repos='http://cran.us.r-project.org')
}
library(benchmarkme)


#---------------------------------
if (!require(doMC)){
  install.packages('doMC',repos='http://cran.us.r-project.org')
}
library(doMC)


#---------------------------------  plotting
if (!require(pdftools)){
  install.packages('pdftools',repos='http://cran.us.r-project.org')
}
library(pdftools)


#--------------------------------- 
if (!require(ggpubr)){
  install.packages('ggpubr',repos='http://cran.us.r-project.org')
}
library(ggpubr)


#--------------------------------- 
if (!require(cowplot)){
  install.packages('cowplot',repos='http://cran.us.r-project.org')
}
library(cowplot)


#--------------------------------- 
if (!require(gridExtra)){
  install.packages('gridExtra',repos='http://cran.us.r-project.org')
}
library(gridExtra)


#--------------------------------- 
if (!require(scales)){
  install.packages('scales',repos='http://cran.us.r-project.org')
}
library(scales)


#--------------------------------- 
if (!require(ggplot2)){
  install.packages('ggplot2',repos='http://cran.us.r-project.org')
}
library(ggplot2)


#--------------------------------- 
if (!require(ggsignif)){
  install.packages('ggsignif',repos='http://cran.us.r-project.org')
}
library(ggsignif)


#--------------------------------- 
if (!require(ggbeeswarm)){
  install.packages('ggbeeswarm',repos='http://cran.us.r-project.org')
}
library(ggbeeswarm)


#--------------------------------- 
if (!require(hrbrthemes)){
  install.packages('hrbrthemes',repos='http://cran.us.r-project.org')
}
library(hrbrthemes)

#--------------------------------- 
if (!require(gplots)){
  install.packages('gplots',repos='http://cran.us.r-project.org')
}
library(gplots)


#--------------------------------- 
if (!require(pheatmap)){
  install.packages('pheatmap',repos='http://cran.us.r-project.org')
}
library(pheatmap)


#--------------------------------- 
if (!require(dendextend)){
  install.packages('dendextend',repos='http://cran.us.r-project.org')
}
library(dendextend)


#--------------------------------- 
if (!require(tidyverse)){
  install.packages('tidyverse',repos='http://cran.us.r-project.org')
}
library(tidyverse)


#---------------------------------  Analysis
if (!require(reshape2)){
  install.packages('reshape2',repos='http://cran.us.r-project.org')
}
library(reshape2)


#---------------------------------  
if (!require(Matrix)){
  install.packages('Matrix',repos='http://cran.us.r-project.org')
}
library(Matrix)


#---------------------------------  
if (!require(FNN)){
  install.packages('FNN',repos='http://cran.us.r-project.org')
}
library(FNN)

#---------------------------------  
if (!require(randomForest)){
  install.packages('randomForest',repos='http://cran.us.r-project.org')
}
library(randomForest)

#---------------------------------  
if (!require(caret)){
  install.packages('caret',repos='http://cran.us.r-project.org')
}
library(caret)


#---------------------------------  
if (!require(pryr)){
  install.packages('pryr',repos='http://cran.us.r-project.org')
}
library(pryr)


#---------------------------------  
if (!require(stringr)){
  install.packages('stringr',repos='http://cran.us.r-project.org')
}
library(stringr)

#---------------------------------  
if (!require(Hmisc)){
  install.packages('misc',repos='http://cran.us.r-project.org')
}
library(Hmisc)


#---------------------------------  
if (!require(dplyr)){
  install.packages('dplyr',repos='http://cran.us.r-project.org')
}
library(dplyr)


#---------------------------------  
if (!require(cluster)){
  install.packages('cluster',repos='http://cran.us.r-project.org')
}
library(cluster)


#---------------------------------  
if (!require(gprofiler2)){
  install.packages('gprofiler2',repos='http://cran.us.r-project.org')
}
library(gprofiler2)


#---------------------------------  
if (!require(SummarizedExperiment)){
  install.packages('SummarizedExperiment',repos='http://cran.us.r-project.org')
}
library(SummarizedExperiment)


#---------------------------------  
if (!require(gtools)){
  install.packages('gtools',repos='http://cran.us.r-project.org')
}
library(gtools)


#---------------------------------  
if (!require(Seurat)){
  devtools::install_version('Seurat', version = '3.2.2', dependencies=TRUE, upgrade='never', repos = c('http://cran.us.r-project.org','http://bioconductor.org/packages/3.12/data/annotation','http://bioconductor.org/packages/3.11/bioc','https://bioconductor.org/packages/3.11/workflows','http://bioconductor.org/packages/3.11/data/experiment'))
}
library(Seurat)





