#This handy script is taken from https://stat.ethz.ch/pipermail/r-help/2010-November/259210.html



  ##### FUNCTION DEFS #####

listnames.get <- function(
  list.obj,
  do.basename=TRUE,
  do.name.chain=TRUE,
  ...
)
{
  # VALIDATE
  if(!is.list(list.obj)) stop("Argument 'list.obj' must be a list.")
  # /
  
  #---------------------------------------------------------------------------
  # CORE FUNCTION
  #---------------------------------------------------------------------------
  
  listnames.get.core <- function(
    list.obj,
    do.basename=TRUE,
    do.name.chain=TRUE,
    buffer,
    ...
  )
  {
    if(!exists("index", buffer))
    {
      buffer$index 	<- new.env(parent=emptyenv())
      buffer$index 	<- NULL
      buffer$name		<- NULL
    }
    
    jnk <- sapply(1:length(list.obj), function(x)
    {
      list.branch 	<- list.obj[x]
      list.branch.nme	<- names(list.branch)
      if(do.basename) list.branch.nme <- basename(list.branch.nme)
      list.obj.updt	<- list.branch[[1]]
      
      # UPDATE BUFFER
      buffer$run		<- c(buffer$run, x)
      if(do.name.chain)
      {
        buffer$name		<- c(buffer$name, list.branch.nme)
      } else
      {
        buffer$name		<- list.branch.nme
      }
      # /
      
      index.crnt		<- paste(as.character(buffer$run), collapse="-")
      index.crnt		<- data.frame(
        name=paste(buffer$name, collapse="$"),
        index=index.crnt,
        stringsAsFactors=FALSE
      )
      index.updt		<- rbind(buffer$index, index.crnt)
      buffer$index 	<- index.updt
      
      if(is.list(list.obj.updt))
      {
        listnames.get.core(
          list.obj=list.obj.updt,
          do.basename=do.basename,
          do.name.chain=do.name.chain,
          buffer=buffer
        )
      }
      
      # UPDATE BUFFER
      buffer$run	<- buffer$run[-length(buffer$run)]
      buffer$name	<- buffer$name[-length(buffer$name)]
      # /
      
      return(NULL)
    })
    
    return(TRUE)
  }
  
  # /CORE FUNCTION ----------
  #---------------------------------------------------------------------------
  # APPLICATION
  #---------------------------------------------------------------------------
  
  assign("buffer", new.env(parent=emptyenv()), envir=environment())
  
  listnames.get.core(
    list.obj=list.obj,
    do.basename=do.basename,
    buffer=buffer
  )
  
  # /APPLICATION ----------
  
  return(buffer$index)
}

listbranch.get <- function(
  list.obj,
  query,
  do.strict=TRUE,
  do.rtn.val=TRUE,
  msg.error=NULL,
  ...
)
{
  # VALIDATE
  if(!is.list(list.obj)) stop("Argument 'list.obj' must be a list.")
  # /
  
  # ESTABLISH LIST INDEX
  list.index	<- listnames.get(
    list.obj=list.obj,
    do.basename=TRUE,
    do.name.chain=TRUE
  )
  list.index.nms <- list.index$name
  # /
  
  # SEARCH FOR QUERY
  if(do.strict)
  {
    query.0	<- query
    query <- gsub("\\$", "\\\\$", query)
    query <- gsub("\\.", "\\\\.", query)
    query <- paste("^", query, "$", sep="")
  }
  idx <- grep(query, list.index.nms, perl=TRUE)
  
  if(!length(idx))
  {
    if(is.null(msg.error))
    {
      msg.error <- paste("Query not successful: '", query.0, "' ('",
                         query, "')", sep="")
    }
    stop(cat(msg.error, sep="\n"))
  }
  # /
  
  # BUILDING RECURSIVE INDEX
  idx <- list.index$index[idx]
  idx <- as.numeric(unlist(strsplit(idx, split="-")))
  # /
  
  if(do.rtn.val)
  {
    # RECURSIVE INDEXING
    rtn <- list.obj[[idx]]
    # /
  } else
  {
    rtn <- idx
  }
  
  return(rtn)
}

##### EXAMPLE #####

# my.list <- list(
#   a=list(a.1="a", a.2=list(a.2.1="a", a.2.2="b"), a.3=list(a.3.1="a"),
#          b=list(b.1=list(b.1.1="a"), b.2="b"),
#          c="a"
#   ))
#   
#   listnames.get(list.obj=my.list, do.basename=TRUE, do.name.chain=TRUE)
#   
#   listbranch.get(list.obj=my.list, query="a$a.2$a.2.2",
#                  do.strict=TRUE, do.rtn.val=TRUE)
#   listbranch.get(list.obj=my.list, query="a$a.2$a.2.2",
#                  do.strict=TRUE, do.rtn.val=FALSE)
#   

  
  
  #Another handy function, modified from a version provided by Marco Sandri: https://stackoverflow.com/questions/44859720/change-data-type-of-elements-in-a-nested-list
  
  # Convert S3 list to charcter
  CharConvert <- function(x,convert=NULL){
    if (!is.null(x)) {
      
      print(class(x))
      
      if(typeof(x)=="list"){
      for(i in 1:length(x)){
        names(x)[[i]]<-c("1","2")[i]
        }
      }
    
      if (typeof(x)!="list" && convert) {
        
        y <- as.character(x)
        
      } 
      else if(typeof(x)!="list" && !convert){
        y<-x
        }
      else {
        y <- lapply(x, CharConvert, convert )
      }
    } else { 
      y <- x
    }
    print(class(y))
    return(y)
  }
  

  

    RemoveNonTerminal<-function(x){
      indicesList<-strsplit(x$index,"-")
      for(i in 1:length(indicesList)){
        
        comEntry<-indicesList[[i]]
        numInd<-length(indicesList[[i]])
        
        #Do any other index fully contain this one?
        for( j in 1:length(indicesList)){
          if(i!=j){
            entry<-indicesList[[j]]
            
            if(length(entry)>numInd){
            
            app<-vector(length = length(entry)-numInd,mode='double')
            app[1:length(app)]<-NA
            comEntryAppended<-c(comEntry,app)
            
            if(sum((comEntryAppended==entry)[which(!is.na(comEntryAppended==entry))]) == numInd ){
              #This index is fully contained, wipe it from list
              indicesList[[i]]<-NA
              x[i,]<-NA
              break
            }
            }
          }
          
        }
        
        
      }
      x<-x[!is.na(x$index),]
      rownames(x)<-1:dim(x)[1]
      return(x)
    }

    ChangeEntry <- function(dendrogram, indices, newentry=NULL,nestDepth=0,howDeep=NULL,mode='add'){
      howDeep=length(indices)
      
      if(nestDepth==howDeep){
        if(mode=="clear"){

        dendrogram<-NULL
        
        }
        else if(mode=='update'){
        dendrogram<-newentry
        }
        else if(mode=='add'){
        size<-length(dendrogram[[as.numeric(indices[nestDepth])]])
        if(typeof(dendrogram[[as.numeric(indices[nestDepth])]]) == "list"){
        dendrogram[[as.numeric(indices[nestDepth])]][[size+1]]<-newentry
        }}else{
          dendrogram[[as.numeric(indices[nestDepth])]]<-as.list(dendrogram[[as.numeric(indices[nestDepth])]])
          dendrogram[[as.numeric(indices[nestDepth])]][[size+1]]<-newentry
        }
        return(dendrogram)
        }
      
      else{
        nestDepth<-nestDepth+1
        dendrogram[[as.numeric(indices[nestDepth])]]<-ChangeEntry(dendrogram = dendrogram[[as.numeric(indices[nestDepth])]],indices=indices,newentry=newentry,nestDepth=nestDepth,howDeep=howDeep,mode=mode)
        
      }
      return(dendrogram)
      
    }    
    
    
    #Collapses empty nodes
    CollapseSingles<-function(dendrogram, indices,nestDepth=0,howDeep=NULL){
      howDeep=length(indices)
      
      if(nestDepth==(howDeep-1)){
          
          if(length(dendrogram)==0){
            dendrogram<-NULL
          }
        else if(length(dendrogram)==1){
          dendrogram<-dendrogram[[1]]
        }
          
          return(dendrogram)
             }
      else{
        nestDepth<-nestDepth+1
        
        dendrogram[[as.numeric(indices[nestDepth])]]<-CollapseSingles(dendrogram = dendrogram[[as.numeric(indices[nestDepth])]],indices,nestDepth=nestDepth,howDeep)
        
      }
      return(dendrogram)
      
    }    
    
    
    FetchSubDend <- function(dendrogram, indices, nestDepth=0,howDeep=NULL){
      howDeep=length(indices)
      
      if(nestDepth==howDeep){
          subdendrogram<-dendrogram
          return(subdendrogram)
      }
      else if(nestDepth>howDeep){
        print("Error: indices went too far!")
      }
      else{
        nestDepth<-nestDepth+1
        subdendrogram<-  FetchSubDend(dendrogram = dendrogram[[as.numeric(indices[nestDepth])]],indices,nestDepth=nestDepth,howDeep)
        
        }
      
      
    }
    
    


  
  
  
    