LaminarDepth <- function(obj){
  
  #compute laminar depth
  obj[['laminar_depth']] <-NA
  
  
  #compute laminar depth
  #create intervals to prject depth values onto. 
  r<-seq(0, sum(unique(obj$GeneralLayers) != ''),1)
  
  intervals<-lapply(r,FUN=function(x){
    
    if(x != sum(unique(obj$GeneralLayers) != '')){
      vals<-c(x, x+1)
      return(vals)
    }else{
      return(NA)
    }
    
  })
  
  intervals<-intervals[!is.na(intervals)]
  names(intervals)<-rev(sort(unique(obj$GeneralLayers)[unique(obj$GeneralLayers) != '']))
  
  
  for(layer in unique(obj$GeneralLayers)){
    
    subobj<-subset(obj, cells=WhichCells(obj, expression=GeneralLayers==layer))
    

    
    #fit loess curve
    df<-data.frame( subobj@reductions$coords@cell.embeddings)
    df<-df[order(df$Coord_1),]
    
    
    #add ghost points to ensure curve fits through centre of layer
    
    #get furthest left point
    minpoint <- df[1,]
    maxpoint <- df[dim(df)[1], ]
    
    #get thickness of band at each end, by seeing how many cells have similar vertical coord value. also need range to spread them over
    mincells <- which(abs(df[,2] - minpoint[1,2]) < 100)
    
    #keep those in 2000 range
    sub <- df[mincells,1]
    #sub<- sub[which(abs(abs(sub) - abs(minpoint[1,1])) < 2000)]
    mincells<-mincells[which(abs(abs(sub) - abs(minpoint[1,1])) < 2000)]
    
    minthickness <- length(mincells)
    minrange <-  range(df[mincells,1])[2] - range(df[mincells,1])[1]
    
    
    #get thickness of band at each end, by seeing how many cells have similar vertical coord value. also need range to spread them over
    maxcells <- which(abs(abs(df[,2]) - abs(maxpoint[1,2])) < 100)
    
    #keep those in 2000 range
    sub <- df[maxcells,1]
    #sub<- sub[which(abs(abs(sub) - abs(maxpoint[1,1])) < 2000)]
    maxcells<-maxcells[which(abs(sub - maxpoint[1,1]) < 2000)]
    
    maxthickness <- length(maxcells)
    maxrange <-  range(df[maxcells,1])[2] - range(df[maxcells,1])[1]
    
    #add ghost data
    ghostmin <- data.frame(rep(minpoint[1,1], minthickness) , seq(minpoint[1,2], minpoint[1,2] - minrange, length.out=minthickness))
    ghostmax <- data.frame(rep(maxpoint[1,1], maxthickness) , seq(maxpoint[1,2], maxpoint[1,2] - maxrange, length.out=maxthickness ))
    colnames(ghostmin) <-colnames(df)
    colnames(ghostmax) <-colnames(df)
    ghost<-rbind(ghostmin, ghostmax)
    dfnew<-rbind(df,ghost)
    
    dfnew<-dfnew[order(dfnew$Coord_1),]
    rownames(dfnew) <- c(rownames(df), make.unique(rep('Ghost', maxthickness + minthickness)))
    
    
    fit<-loess(data=dfnew, Coord_2 ~ Coord_1, span=0.5)
    plot(dfnew$Coord_1,dfnew$Coord_2)
    lines(dfnew$Coord_1, predict(fit), col='red', lwd=3)
    
    res<-fit$residuals
    #res<-res+min(res)
    
    #transform the residuals to cover the range corresponding to this layer
    bounds<-intervals[[layer]]
    
    newRes<-(((bounds[2] - bounds[1]) / (max(res)-min(res))) * (res-min(res))) + bounds[1]
    
    obj[['laminar_depth']][colnames(subobj),] <- newRes[colnames(subobj)]
    
  }
  
  #create intervals to project depth values onto. 
  # r<-seq(0, sum(unique(obj$GeneralLayers) != ''),1)
  # 
  # intervals<-lapply(r,FUN=function(x){
  #   
  #   if(x != sum(unique(obj$GeneralLayers) != '')){
  #     vals<-c(x, x+1)
  #     return(vals)
  #   }else{
  #     return(NA)
  #   }
  #   
  # })
  # 
  # intervals<-intervals[!is.na(intervals)]
  # names(intervals)<-rev(sort(unique(obj$GeneralLayers)[unique(obj$GeneralLayers) != '']))
  # 
  # #need all th enearest neighbours
  # dat<-obj@reductions$coords@cell.embeddings
  # dat<-dat[WhichCells(obj, expression=GeneralLayers!=''),]
  # nn<-get.knn(dat, k=2)
  # ind<-nn$nn.index
  # 
  # rownames(ind) <- rownames(dat)
  # 
  # #try getting set for points that are closest. look for cells with most neighbours from a different layers
  # sub<-subset(obj,cells=rownames(dat))
  # 
  # #we'll need a diostance matrix
  # distMat<-as.matrix(dist(as.data.frame(dat), method = 'euclidean'))
  # 
  # layers<-sort(unique(sub$GeneralLayers))
  # 
  # 
  # for(i in 1:length(layers)){
  #   
  #   
  #   layer <- layers[i]
  #   
  #   if(i == 1){
  #     upperLayer <- NA
  #     lowerLayer <- layers[i+1]
  #   }else if(i == length(layers)){
  #     lowerLayer <- NA
  #     upperLayer<- layers[i-1]
  #   }else{
  #     lowerLayer <- layers[i+1]
  #     upperLayer<- layers[i-1]
  #   }
  #   
  #   subind<-ind[WhichCells(sub, expression=GeneralLayers==layer),]
  #   L<-apply(subind, 2,FUN = function(x) { sub$GeneralLayers[x] } )
  #   
  #   tally<-apply(L, 1, FUN= function(x) {
  #     
  #     t<-table(x)
  #     res<-t[c(upperLayer,lowerLayer)]
  #     
  #     res<-res[!is.na(res)]
  #     
  #     if(length(res)==0){
  #       return(NA)
  #     }
  #     
  #     ind<-grep(max(res), res)
  #     
  #     if(length(ind==1)){
  #       return(names(res)[ind])
  #     }else{return(NA)}
  #     
  #   })
  #   
  #   
  #   
  #   
  #   if(is.na(lowerLayer) && !is.na(upperLayer) ){
  #     
  #     #we're at the bottom, judge depth by distance from top of layer
  #     
  #     #get cells
  #     bordercells<- rownames(subind)[grep(upperLayer, tally)]
  #     
  #     #call all of these cells the bottom of the range. Layer depth is measure as distance from these cells
  #     othercells <- WhichCells(sub, expression=GeneralLayers==layer)[WhichCells(sub, expression=GeneralLayers==layer) %nin% bordercells]
  #     
  #     #for each of these cells, find distance to nearest border cell
  #     subd<-distMat[othercells, bordercells]
  #     
  #     otherdepth<-apply(subd, 1, FUN=function(x){
  #       return(min(x))
  #     })
  #     
  #     
  #     borderdepth<-apply(subd, 2, FUN=function(x){
  #       return(min(x))
  #     })
  #     borderdepth<- -borderdepth
  #     #let the highest value here = smallest value in the other cells
  #     diff<-min(otherdepth) - max(borderdepth)
  #     borderdepth <- borderdepth + diff      
  # 
  #     depth <- c(borderdepth, otherdepth)  
  #     depth<-depth + abs(min(depth))
  #     
  #     #normalise range to 1-0
  #     depth<- depth/max(depth)
  #     depth<-1-depth
  #     
  #     #adjust by interval
  #     depth<-depth + intervals[[layer]][1]
  #     
  #     
  #     
  #   }else if(!is.na(lowerLayer) && is.na(upperLayer)){
  #     
  #     #we're at the top, judge distance from bottom of layer
  #     
  #     #get cells
  #     bordercells<- rownames(subind)[grep(lowerLayer, tally)]
  #     
  #     #call all of these cells the bottom of the range. Layer depth is measure as distance from these cells
  #     othercells <- WhichCells(sub, expression=GeneralLayers==layer)[WhichCells(sub, expression=GeneralLayers==layer) %nin% bordercells]
  #     
  #     #for each of these cells, find distance to nearest border cell
  #     subd<-  distMat[othercells, bordercells]
  #     
  #     otherdepth<-apply(subd, 1, FUN=function(x){
  #       return(min(x))
  #     })
  #     
  #     
  #     borderdepth<-apply(subd, 2, FUN=function(x){
  #       return(min(x))
  #     })
  #     borderdepth<- -borderdepth
  #     #let the highest value here = smallest value in the other cells
  #     diff<-min(otherdepth) - max(borderdepth)
  #     borderdepth <- borderdepth + diff    
  #     
  #     
  #     depth <- c(borderdepth, otherdepth)  
  #     depth<-depth + abs(min(depth))
  #     
  #     #normalise range to 0-1
  #     depth<-depth/max(depth)
  #     
  #     #adjust by interval
  #     depth<-depth + intervals[[layer]][1]
  #     
  #     
  #   }else if(!is.na(lowerLayer) && !is.na(upperLayer)){
  #     
  #     #we're in the middle. Fit use two curves and judge distance from each 
  #     
  #     #get cells
  #     lowercells<- rownames(subind)[grep(lowerLayer, tally)]
  #     uppercells<- rownames(subind)[grep(upperLayer, tally)]
  #     
  #     othercells <- WhichCells(sub, expression=GeneralLayers==layer)[WhichCells(sub, expression=GeneralLayers==layer) %nin% c(lowercells, uppercells)]
  #     
  #     
  #     lowerd<-  distMat[othercells, lowercells]
  #     upperd<-  distMat[othercells, uppercells]
  #     
  #     lowdist<-apply(lowerd, 1, FUN=function(x){
  #       return(min(x))
  #     })
  #     
  #     updist<-apply(upperd, 1, FUN=function(x){
  #       return(min(x))
  #     })
  #     
  #     totalDist <- lowdist + updist
  #     depth <- lowdist / totalDist
  #     
  #     #normalise
  #     depth<-depth/max(depth)
  #     
  #     #adjust by interval
  #     depth<-depth + intervals[[layer]][1]
  #     
  #   }
  #   
  #   obj[['laminar_depth']][names(depth),]<-depth
  #   
  #   
  # 
  #   print(range(depth))
  #   
  # }
  
  
  

  
  
  return(obj)
  
  
  
  
  
  
  
}

