#This script is a sanity check that you have the right folders in the right places. it'll tell you if you're missing directories you should have

if(!dir.exists(paste0(path,'/output'))){
  warning("You don't have an output folder in your pipeline directory! Creating folder...")
  dir.create(paste0(path,'/output'))
  dir.create(paste0(path,'/output/scrnaseq'))
  dir.create(paste0(path,'/output/spatial'))
}

if(!dir.exists(paste0(path,'/output/scrnaseq'))){
  warning("You don't have a directory for the single cell RNA seq data in your output folder! Creating folder...")
  dir.create(paste0(path,'/output/scrnaseq'))
}


if(!dir.exists(paste0(path,'/output/spatial'))){
  warning("You don't have a directory for the spatial data in your output folder! Creating folder...")
  dir.create(paste0(path,'/output/spatial'))
}

if(!dir.exists(paste0(path,'/input'))){
  stop("You don't have an input folder in your pipeline directory! All the data needed for the pipeline has to be in a folder called 'input' with subdirectories named
       'developmental_single_cell', 'external_reference', and  'supplementary'. You can download our data with the correct directory structure here: <link>")
}