
#Functions to help go through dendrogram while building iteratively 



#function to remove NA entries from dendrogram
RemoveNA<-function(dend){
  newdend<-dend
  for(i in 1:length(dend) && typeof(dend)=="list"){
    if( typeof(dend[[i]])=='double'){
      if(dend[[i]]==0 ){
        newdend[[i]]<-NULL
      }
    }
  }
  
  return(newdend)
  
}



#This function computes silhouette score for a range of clusterings to inform on number of clusters to seek
ComputeSilhouette<-function(d,vals){
  clu<-hclust(d,method='average')
  max<-vals[2]
  min<-vals[1]
  out<-vector()
  s<-seq(min,max)
  for(i in s){
    cut<-cutree(clu,i)
    score<-cluster::silhouette(cut,dist=d)
    score<-mean(score[,3])
    out<-c(out,score)
    names(out)[length(out)]<-as.character(i)
  }
  return(out)
}


#This is an admin function. It goes through the dendrogram and corrects the value to refer the original full data, not the subsetted data
CorrectDendEntries<-function(dend,seuratObject,masterClassification){
  if(typeof(dend) == 'integer'){
    ind<-dend[1]
    cell<-seuratObject@assays[['RNA']]@data@Dimnames[[2]][ind]
    newEntry<-match(cell,rownames(masterClassification))
    dend[1]<-as.integer(newEntry)
  }
  
  return(dend)
}


#This function helps us to find the index of the cluster of interest by labelling it. 
LabelNode <- function(dendNode,cellSet,cluster,foundIt=FALSE) {
  foundInd<-0
  for(i in 1:length(dendNode)){
    cells<-labels(dendNode[[i]])
    if(length(cells)==length(cellSet) && sum(is.na(match(cellSet,cells)))==0 ){
      names(dendNode)[[i]]<-'Cluster'
      foundIt<-TRUE
      foundInd<-i
    }
  }
  
  if(foundIt){
    for(i in 1:length(dendNode)){
      if(i!=foundInd ){
        names(dendNode)[[i]]<-'Not'
        
      }
    }
    
  }
  
  return(dendNode)
  
}


#Gives each list in the dendrogram a character name. Note we need to do this becasue we require character names of the lists to search through the dendrogram by node name
CharacterDendname<-function(dend){
  
  labs<-as.character(seq(1,10))
  nameVect<-NULL
  if(typeof(dend)=='list'){
    for(i in 1:length(dend)){
      nameVect<-c(nameVect,labs[i])
    }
    
    names(dend)<-nameVect
  }
  return(dend)
  
}


#This is an important function - we use it to append branches of the dendrogram to different locations (merge failed groups with nearest neighbour branches)
ChangeEntry <- function(dendrogram, indices, newentry=NULL,nestDepth=0,howDeep=NULL,mode='add'){
  howDeep=length(indices)
  
  if(nestDepth==howDeep){
    if(mode=="clear"){
      
      dendrogram<-NULL
      
    }
    else if(mode=='update'){
      dendrogram<-newentry
    }
    else if(mode=='add'){
      size<-length(dendrogram[[as.numeric(indices[nestDepth])]])
      if(typeof(dendrogram[[as.numeric(indices[nestDepth])]]) == "list"){
        dendrogram[[as.numeric(indices[nestDepth])]][[size+1]]<-newentry
      }}else{
        dendrogram[[as.numeric(indices[nestDepth])]]<-as.list(dendrogram[[as.numeric(indices[nestDepth])]])
        dendrogram[[as.numeric(indices[nestDepth])]][[size+1]]<-newentry
      }
    return(dendrogram)
  }
  
  else{
    nestDepth<-nestDepth+1
    dendrogram[[as.numeric(indices[nestDepth])]]<-ChangeEntry(dendrogram = dendrogram[[as.numeric(indices[nestDepth])]],indices=indices,newentry=newentry,nestDepth=nestDepth,howDeep=howDeep,mode=mode)
    
  }
  return(dendrogram)
  
}    

#This function is used where a binary split has had a branch removed, leaving a single branch remainign. It resolves that branch with the parent
CollapseSingles<-function(dendrogram, indices,nestDepth=0,howDeep=NULL){
  howDeep=length(indices)
  
  if(nestDepth==(howDeep-1)){
    
    if(length(dendrogram)==0){
      dendrogram<-NULL
    }
    else if(length(dendrogram)==1){
      dendrogram<-dendrogram[[1]]
    }
    
    return(dendrogram)
  }
  else{
    nestDepth<-nestDepth+1
    
    dendrogram[[as.numeric(indices[nestDepth])]]<-CollapseSingles(dendrogram = dendrogram[[as.numeric(indices[nestDepth])]],indices,nestDepth=nestDepth,howDeep)
    
  }
  return(dendrogram)
  
}    


#This extracts a sub dendrogram by index
FetchSubDend <- function(dendrogram, indices, nestDepth=0,howDeep=NULL){
  howDeep=length(indices)
  
  if(nestDepth==howDeep){
    subdendrogram<-dendrogram
    return(subdendrogram)
  }
  else if(nestDepth>howDeep){
    print("Error: indices went too far!")
  }
  else{
    nestDepth<-nestDepth+1
    subdendrogram<-  FetchSubDend(dendrogram = dendrogram[[as.numeric(indices[nestDepth])]],indices,nestDepth=nestDepth,howDeep)
    
  }
  
  
}