
#This script computes and save DE genes between groups for later reference

## ----receive input from nextflow----------------------------------------------
#Get parameters
args <- commandArgs(TRUE)
path<-args[1]
file<-args[2]

print(path)
timepoints<-substr(file,12,nchar(file)-17)



#Load standard package list
source(paste0(path,'/bin/auxiliary/DirectoryChecker.R'))
source(paste0(path,'/bin/auxiliary/PackageLoader.R'))


#check directory
if(!dir.exists(paste0(path,'/output/scrnaseq/',timepoints,'/DEgenes'))){
  dir.create(paste0(path,'/output/scrnaseq/',timepoints,'/DEgenes'))
}



plotPath<-paste0(path,'/output/scrnaseq/',timepoints,'/DEgenes')

plot_file_name<-paste(plotPath,'/DE_genes.pdf',sep='')
pdf(file=plot_file_name,width=24,height = 24) 

## ----echo=FALSE---------------------------------------------------------------



#check ram
RAM<-get_ram()
print(paste(RAM,'RAM passed to Rscript'))

ncor=detectCores()
print(paste(ncor,'cores detected'))
plan("multiprocess", workers = ncor )
options(future.globals.maxSize = 10000 * 1024^2)



#set up plotting colours
FeatureCol<-c('gray',"#1b75bb","#faaf40")
HeatCol<- colorRampPalette(colors = c("#1b75bb", "black","#faaf40"))(1000)
pairs.breaks <- seq(-1.5, 1.5, length.out=1001);



#load integrated data
load(file)


#without stressed group
integratedNoStress<-subset(integrated,cells=WhichCells(integrated,expression=major_cluster_label!='Stressed' & major_cluster_label!='FailedClassification'))
DefaultAssay(integratedNoStress)<-'integrated'
integratedNoStress<-FindVariableFeatures(integratedNoStress)
integratedNoStress<-ScaleData(integratedNoStress)
integratedNoStress<-RunPCA(integratedNoStress)
integratedNoStress<-RunUMAP(integratedNoStress,dims=1:15)
DimPlot(integratedNoStress,group.by='orig.ident',label=T)




#Major group DE genes ----

integratedSubset<-subset(integrated,cells=WhichCells(integrated,expression=major_cluster_label %nin% c('FailedClassification','Stressed','Meis2')))

Idents(integratedSubset)<-'major_cluster_label'
majorClassMarkers<-FindAllMarkers(integratedSubset,only.pos = T,assay = 'RNA',logfc.threshold = log(1.5))
#Filter by pval
majorClassMarkers<-majorClassMarkers[which(majorClassMarkers$p_val_adj<=0.01),]
write.csv(majorClassMarkers,file=paste0(plotPath,'/Major_Class_Markers.csv',sep=''))

topDEGenes<-majorClassMarkers %>% group_by(cluster) %>% top_n(n=10, avg_logFC)

avg<-AverageExpression(integratedSubset,return.seurat = T,assays = 'RNA')
Input<-avg[['RNA']]@scale.data
Input<-Input[c('DACH1','NPAS1','NPAS3','IGFBP3','ETV1','ERBB4',unique(topDEGenes$gene)),]


gplots::heatmap.2(as.matrix(Input),
                  breaks = pairs.breaks,
                  #symbreaks=F,
                  keysize = 0.8,
                  key = T,
                  main=NA,
                  col = HeatCol,
                  key.xlab="z-score normalised expression",
                  symkey = F,
                  cexRow=0.7,
                  cexCol = 1,
                  Rowv= F,
                  Colv =F,
                  # ColSideColorsSize = 0.5,
                  dendrogram = "none",
                  scale = "none",
                  #colsep = colsep,
                  sepcolor = "black",
                  labRow = rownames(Input),
                  trace="none",
                  density.info="none",
                  srtCol=0,
                  adjCol=c(0.5,1),
                  #RowSideColors=c(rbind(cluster.cols,cluster.cols))
)


#Minor Class Markers

Idents(integratedSubset)<-'cluster_label'
minorClassMarkers<-FindAllMarkers(integratedSubset,only.pos = T,assay = 'RNA',logfc.threshold = log(1.5))

#Filter by pval
minorClassMarkers<-minorClassMarkers[which(minorClassMarkers$p_val_adj<=0.01),]
write.csv(minorClassMarkers,file=paste0(plotPath,'/Minor_Class_Markers.csv'))
write.csv(minorClassMarkers,file=paste0('Minor_Class_Markers.csv'))

topDEGenes<-minorClassMarkers %>% group_by(cluster) %>% top_n(n=5, avg_logFC)
#topDEGenes<-topDEGenes[order(match(topDEGenes$cluster,labels(majorGroupDendrogram))),]


avg<-AverageExpression(integratedSubset,assays = 'RNA',slot='data',return.seurat = T)

Input<-avg[['RNA']]@scale.data


col <- colorRampPalette(colors = c("#1b75bb", "black","#faaf40"))(1001)
pairs.breaks <- seq(-2.5, 2.5, length.out=1001);

topDEGenes<-topDEGenes[order(match(topDEGenes$cluster,labels(dend))),]
labs<-labels(dend)[order(order.dendrogram(dend))]
topDEGenes<-topDEGenes[topDEGenes$cluster!='Meis2_1',]
topDEGenes<-topDEGenes[order(match(as.character(topDEGenes$cluster),unlist(lapply(str_split(labels(dend),'\\|'),FUN= function(x) x[2])))),]

Input<-Input[unique(topDEGenes$gene),]


gplots::heatmap.2(as.matrix(Input),
                  breaks = pairs.breaks,
                  #symbreaks=F,
                  keysize = 0.8,
                  margins=c(8,8),
                  key = T,
                  main=NA,
                  col = HeatCol,
                  symkey = F,
                  cexRow=0.75,
                  cexCol = 1.2,
                  Rowv= F,
                  Colv =dend,
                  # ColSideColorsSize = 0.5,
                  dendrogram = "column",
                  scale = "none",
                  #colsep = colsep,
                  sepcolor = "black",
                  labRow = rownames(Input),
                  trace="none",
                  density.info="none",
                  srtCol=45,
                  adjCol=c(1,1)
                  #RowSideColors=c(rbind(cluster.cols,cluster.cols))
)

#now plot with just colour bars


# cols<-hue_pal()(length(labels(dend)))
# cols<-cols[labels(dend)]
# cols<-cols[order(order.dendrogram(dend))]
# names(cols)<-sort(unique(integratedNoMeis[['cluster_label']][,1]))
# colbar<-cols[integrated[['cluster_label']][,1]]
# 
# 
# gplots::heatmap.2(as.matrix(Input),
#                   breaks = pairs.breaks,
#                   #symbreaks=F,
#                   keysize = 0.8,
#                   margins=c(8,8),
#                   key = T,
#                   main=NA,
#                   col = HeatCol,
#                   symkey = F,
#                   cexRow=0.75,
#                   cexCol = 1.2,
#                   Rowv= F,
#                   Colv =dend,
#                   # ColSideColorsSize = 0.5,
#                   ColSideColors = cols,
#                   dendrogram = "column",
#                   scale = "none",
#                   #colsep = colsep,
#                   sepcolor = "black",
#                   labRow = rownames(Input),
#                   trace="none",
#                   density.info="none",
#                   srtCol=45,
#                   adjCol=c(1,1)
#                   #RowSideColors=c(rbind(cluster.cols,cluster.cols))
# )

dev.off()


# 
# #Intra-Class Markers
# intraClassMarkers<-data.frame()
# integratedSubset<-subset(integrated,cells=WhichCells(integrated,expression=major_cluster_label!='FailedClassification' & major_cluster_label!='Stressed' & major_cluster_label!='Meis2'))
# Idents(integratedSubset)<-'cluster_label'
# for(group in unique(integratedSubset[['major_cluster_label']][,1])){
#   sub<-subset(integratedSubset,cells = WhichCells(integratedSubset,expression=major_cluster_label==group))
#   mark<-FindAllMarkers(sub,logfc.threshold = log(1.5),min.diff.pct = 0.1,only.pos = T,assay='RNA')
#   intraClassMarkers<- rbind(intraClassMarkers,mark)
# }
# intraClassMarkers<- intraClassMarkers[which(intraClassMarkers$p_val_adj<=0.01),]
# write.csv(intraClassMarkers,file=paste(plotPath,'/Intra_Class_Markers.csv',sep=''))
# 
# 
# topDEGenes<-intraClassMarkers %>% group_by(cluster) %>% top_n(n=5, avg_logFC)
# 
# 
# avg<-AverageExpression(integratedSubset,assays = 'integrated',slot='data',return.seurat = T)
# hInput<-avg[['integrated']]@scale.data
# 
# dis<-dist(1-cor(hInput))
# clu<-hclust(dis,method = 'average')
# newdend<-as.dendrogram(clu)
# 
# 
# avg<-AverageExpression(integratedSubset,assays = 'RNA',slot='data',return.seurat = T)
# Input<-avg[['RNA']]@scale.data
# 
# topDEGenes<-topDEGenes[order(match(topDEGenes$cluster,labels(newdend))),]
# Input<-Input[topDEGenes$gene,]
# 
# #Clean entries for clarity
# for(group in unique(integratedSubset[['major_cluster_label']][,1])){
#   c<-grepl(colnames(Input),pattern=paste0("^",group))
#   r<-!grepl(topDEGenes$cluster,pattern=paste0("^",group))
#   Input[r,c]<-NA
# }
# 
# 
# gplots::heatmap.2(as.matrix(Input),
#                   #breaks = pairs.breaks,
#                   #symbreaks=F,
#                   keysize = 0.8,
#                   margins=c(8,8),
#                   key = T,
#                   main=NA,
#                   col = HeatCol,
#                   symkey = F,
#                   cexRow=0.7,
#                   cexCol = 1,
#                   Rowv= F,
#                   Colv =newdend,
#                   # ColSideColorsSize = 0.5,
#                   dendrogram = "column",
#                   scale = "row",
#                   #colsep = colsep,
#                   sepcolor = "black",
#                   labRow = rownames(Input),
#                   trace="none",
#                   density.info="none",
#                   srtCol=45,
#                   adjCol=c(1,1)
#                   #RowSideColors=c(rbind(cluster.cols,cluster.cols))
# )
# 
# #Conserved Markers
# conMarkers<-vector()
# for(clust in unique(integrated[['cluster_label']][,1])){
#   m<-NULL
#   try({m<-FindConservedMarkers(integrated,assay='RNA',ident.1=clust,grouping.var='orig.ident',only.pos=T)})
#   if(ncol(m)==(length(unique(integrated[['orig.ident']]))*3)+2){
#     conMarkers<-rbind(conMarkers,m)
#   }
# }
# conGenes<-unique(rownames(conMarkers))
# 
# 
# #Sample specific markers
# sampMarkers<-list()
# 
# for(samp in unique(integrated[['orig.ident']][,1])){
#   sub<-subset(integrated,cells=WhichCells(integrated,expression=orig.ident==samp))
#   DefaultAssay(sub)<-'RNA'
#   Idents(sub)<-'cluster_label'
#   m<-FindAllMarkers(sub,only.pos = T,logfc.threshold = log(1.5))
#   topm<-m  %>% group_by(cluster) %>% top_n(n=10, avg_logFC)
#   sampMarkers[[samp]]<-topm
# }
# sampGenes<-unique(unlist(lapply(sampMarkers,FUN = function(x) x$gene)))
# 
# 
# 
# #stress Markers
# integrated[['stress_indicator']]<-FALSE
# integrated[['stress_indicator']][WhichCells(integrated,expression=major_cluster_label=='Stressed'),]<-TRUE
# Idents(integrated)<-'stress_indicator'
# StressDEGenes<-FindAllMarkers(integrated,assay ='RNA',only.pos=T, logfc.threshold = log(1.5))
# StressDEGenes<-StressDEGenes[which(StressDEGenes$p_val_adj<0.01),]
# topDEGenes<-StressDEGenes %>% group_by(cluster) %>% top_n(n=20, avg_logFC)
# topDEGenes[order(match(topDEGenes$cluster,sort(unique(integrated[['stress_indicator']][,1])))),]
# 
# Input<-avg[['RNA']]@scale.data
# Input<-Input[topDEGenes$gene,order.dendrogram(majorGroupDendrogram)]
# 
# integrated<-ScaleData(integrated,features=topDEGenes$gene)
# Input<-integrated@assays[['RNA']]@scale.data
# Input<-Input[topDEGenes$gene,order(integrated[['stress_indicator']][,1])]
# 
# gplots::heatmap.2(as.matrix(Input),
#                   breaks = pairs.breaks,
#                   #symbreaks=F,
#                   keysize = 0.8,
#                   margins=c(8,8),
#                   key = T,
#                   main=NA,
#                   col = HeatCol,
#                   symkey = F,
#                   cexRow=0.7,
#                   cexCol = 1,
#                   Rowv= F,
#                   Colv =F,
#                   # ColSideColorsSize = 0.5,
#                   dendrogram = "column",
#                   scale = "none",
#                   #colsep = colsep,
#                   sepcolor = "black",
#                   labRow = rownames(Input),
#                   trace="none",
#                   density.info="none",
#                   srtCol=45,
#                   adjCol=c(1,1)
#                   #RowSideColors=c(rbind(cluster.cols,cluster.cols))
# )
# 
# 
# #Stressed group ----
# stressed<-subset(integrated,cells=WhichCells(integrated,expression=major_cluster_label=='Stressed'))
# DefaultAssay(stressed)<-'integrated'
# stressed<-FindVariableFeatures(stressed, nfeatures=2000)
# stressed<-ScaleData(stressed)
# 
# hInput<-stressed@assays[['integrated']]@scale.data
# dis<-as.dist(1-cor(hInput))
# clu<-hclust(dis,method = 'average')
# dend<-as.dendrogram(clu)
# 
# 
# 
# Idents(stressed)<-'cluster_label'
# DEgenes<-FindAllMarkers(stressed,logfc.threshold = log(1.5),only.pos=T)
# topDEgenes<-DEgenes %>% group_by(cluster) %>% top_n(n=20, avg_logFC)
# topDEgenes<-topDEgenes[order(match(topDEgenes$cluster,sort(stressed[['cluster_label']][,1]))),]
# 
# 
# DefaultAssay(stressed)<-'RNA'
# stressed<-FindVariableFeatures(stressed, nfeatures=2000)
# stressed<-ScaleData(stressed,features = c(stressMarkers,topDEgenes$gene))
# 
# Input<-stressed@assays[['RNA']]@scale.data[,order(stressed[['cluster_label']][,1])]
# cols<-hue_pal()(length(unique(stressed[['cluster_label']][,1])))
# names(cols)<-sort(unique(stressed[['cluster_label']][,1]))
# Input<-Input[c(stressMarkers,topDEgenes$gene),]
# colBar<-cols[stressed[['cluster_label']][order(stressed[['cluster_label']][,1]),1]]
# 
# gplots::heatmap.2(as.matrix(Input),
#                   breaks = pairs.breaks,
#                   #symbreaks=F,
#                   keysize = 0.8,
#                   margins=c(8,8),
#                   key = T,
#                   main=NA,
#                   col = HeatCol,
#                   symkey = F,
#                   cexRow=0.7,
#                   cexCol = 1,
#                   Rowv= F,
#                   Colv =F,
#                   ColSideColors = colBar,
#                   # ColSideColorsSize = 0.5,
#                   dendrogram = "column",
#                   scale = "none",
#                   #colsep = colsep,
#                   sepcolor = "black",
#                   labRow = rownames(Input),
#                   trace="none",
#                   density.info="none",
#                   srtCol=45,
#                   adjCol=c(1,1)
#                   #RowSideColors=c(rbind(cluster.cols,cluster.cols))
# )
# 
# 
# #Count pairwise DE Genes ----
# Pairs<-combn(unique(integrated[['cluster_label']][,1]),2)
# DefaultAssay(integrated)<-'RNA'
# Idents(integrated)<-'cluster_label'
# count<-vector()
# cate<-vector()
# expr<-vector()
# pctDiff<-vector()
# for(i in 1:dim(Pairs)[2]){
#   pair<-Pairs[,i]
#   markers<-FindMarkers(integrated,ident.1=pair[1],ident.2=pair[2],only.pos=T)
#   count<-c(count,dim(markers)[1])
#   
#   split<-str_split(pair,'_')
#   starts<-unlist(lapply(split,FUN = function(x) x[1]))
#   if(starts[1]==starts[2]){
#     cate[i]<-'Within Group'
#   }else{
#     cate[i]<-'Between Groups'
#   }
#   
#   #vals<-FetchData(integrated,rownames(markers))
#   expr<-c(expr,mean(markers$avg_logFC))
#   
#   pctDiff<-c(pctDiff,abs(markers$pct.1-markers$pct.2))
# }
# 
# res<-as.data.frame(cbind(t(Pairs),count,cate,expr))
# colnames(res)<-c('group1','group2','numDEgenes','category','expression')
# res$numDEgenes<-as.numeric(res$numDEgenes)
# res$expression<-as.numeric(res$expression)
# ggplot(res, aes(y=expression, x=numDEgenes,col=category)) + geom_point()
# 
# #Plot density cluster by cluster
# PairList<-apply(Pairs,2,FUN = function(x) list(x))
# plotList<-list()
# for(cluster in sort(unique(integrated[['cluster_label']][,1]))){
#   clusters<-PairList[grep(cluster,PairList)]
#   p<-ggplot(res[grep(cluster,PairList),], aes(x=numDEgenes, fill=category)) +
#     geom_density(alpha=0.4)
#   plotList[[length(plotList)+1]]<-p+ggtitle(cluster)
# }
# plot_grid(plotlist = plotList)
# 
# 
# #Recompute grouping/metaneighbour
# integratedNoStress[['experiment']]<-'Marin'
# integratedSCE<-as.SingleCellExperiment(integratedNoStress,assay = 'integrated')
# DEGenes<-FindAllMarkers(integratedNoStress,assay='RNA',logfc.threshold = log(2),only.pos=T)
# topVarGenes<-unique(DEGenes$gene)
# celltype_NV = MetaNeighborUS(var_genes = topVarGenes,
#                              dat = integratedSCE,
#                              study_id = integratedSCE$experiment,
#                              cell_type = integratedSCE$cluster_label,
#                              fast_version = TRUE)
# dis<-dist(1-celltype_NV)
# clu<-hclust(dis,method = 'average')
# sil<-ComputeSilhouette(dis,c(2,10))
# #numGroups<-names(which(sil==max(sil)))
# #Seek Martinotti, Non-Martinotti + LRP
# numGroups<-4
# 
# #Dendrogram
# dend<-as.dendrogram(clu)
# cut<-cutree(dend,numGroups)
# labels<-cut
# labels<-labels[match(labels(dend),names(labels))]
# labels<-as.numeric(labels)
# clusterCols<-hue_pal()(length(unique(labels)))
# cols<-clusterCols[unique(labels)]
# dend<-dend %>% color_branches(col=clusterCols,clusters=labels)
# dend<-color_labels(dend,col='black')
# plot(rank_branches(dend))
# 
# #Centroid clustering
# topDEgenes<-DEGenes %>% group_by(cluster) %>% top_n(n=5, avg_logFC)
# avg<-AverageExpression(integratedNoStress,assay='integrated',slot='data',return.seurat = T)
# 
# 
# hInput<-avg[['integrated']]@scale.data
# 
# dis<-dist(1-cor(hInput))
# clu<-hclust(dis,method = 'average')
# dend<-as.dendrogram(clu)
# 
# avg<-AverageExpression(integratedNoStress,assay='RNA',slot='data',return.seurat = T)
# Input<-avg[['RNA']]@scale.data
# genes<-topDEgenes[order(match(topDEgenes$cluster, labels(dend))),]
# Input<-Input[genes$gene ,]
# 
# pairs.breaks <- seq(-2, 2, length.out=1001);
# 
# gplots::heatmap.2(as.matrix(Input),
#                   breaks = pairs.breaks,
#                   #symbreaks=F,
#                   keysize = 0.8,
#                   margins=c(8,8),
#                   key = T,
#                   main=NA,
#                   col = HeatCol,
#                   symkey = F,
#                   cexRow=0.7,
#                   cexCol = 1,
#                   Rowv= F,
#                   Colv =dend,
#                   # ColSideColorsSize = 0.5,
#                   dendrogram = "column",
#                   scale = "none",
#                   #colsep = colsep,
#                   sepcolor = "black",
#                   labRow = rownames(Input),
#                   trace="none",
#                   density.info="none",
#                   srtCol=45,
#                   adjCol=c(1,1)
#                   #RowSideColors=c(rbind(cluster.cols,cluster.cols))
# )
# 
# 
# 
# 
# 
# #Plot sample density by cluster
# E16<-subset(integrated,cells=WhichCells(integrated,expression=orig.ident=='E16' & cluster_label!='FailedClassification_1'))
# E16prop<-as.vector(table(E16[['cluster_label']]))/as.vector(table(integrated[['cluster_label']])[names(table(E16[['cluster_label']]))])
# names(E16prop)<-names(table(E16[['cluster_label']]))
# missing<-unique(integrated[['cluster_label']])[unique(integrated[['cluster_label']])[,1] %nin% names(E16prop),1] 
# missing<-missing[-grep('FailedClassification',missing)]
# E16prop[missing]<-0
# 
# integrated[['E16_cluster_density']]<-0
# for(group in names(E16prop)){
#   integrated[['E16_cluster_density']][WhichCells(E16,expression=cluster_label==group),]<-E16prop[group]
# }
# FeaturePlot(integrated,label=T,features = 'E16_cluster_density',pt.size=1.5)+scale_color_gradientn(colors=c('gray',hue_pal()(3)[1]))
# 
# P1<-subset(integrated,cells=WhichCells(integrated,expression=orig.ident=='P1' & cluster_label!='FailedClassification_1'))
# P1prop<-as.vector(table(P1[['cluster_label']]))/as.vector(table(integrated[['cluster_label']])[names(table(P1[['cluster_label']]))])
# names(P1prop)<-names(table(P1[['cluster_label']]))
# missing<-unique(integrated[['cluster_label']])[unique(integrated[['cluster_label']])[,1] %nin% names(P1prop),1] 
# missing<-missing[-grep('FailedClassification',missing)]
# P1prop[missing]<-0
# 
# integrated[['P1_cluster_density']]<-0
# for(group in names(P1prop)){
#   integrated[['P1_cluster_density']][WhichCells(P1,expression=cluster_label==group),]<-P1prop[group]
# }
# FeaturePlot(integrated,label=T,features = 'P1_cluster_density',pt.size=1.5)+scale_color_gradientn(colors=c('gray',hue_pal()(3)[2]))
# 
# 
# P5<-subset(integrated,cells=WhichCells(integrated,expression=orig.ident=='P5' & cluster_label!='FailedClassification_1'))
# P5prop<-as.vector(table(P5[['cluster_label']]))/as.vector(table(integrated[['cluster_label']])[names(table(P5[['cluster_label']]))])
# names(P5prop)<-names(table(P5[['cluster_label']]))
# missing<-unique(integrated[['cluster_label']])[unique(integrated[['cluster_label']])[,1] %nin% names(P5prop),1] 
# missing<-missing[-grep('FailedClassification',missing)]
# P5prop[missing]<-0
# 
# integrated[['P5_cluster_density']]<-0
# for(group in names(P5prop)){
#   integrated[['P5_cluster_density']][WhichCells(P5,expression=cluster_label==group),]<-P5prop[group]
# }
# FeaturePlot(integrated,label=T,features = 'P5_cluster_density',pt.size=1.5)+scale_color_gradientn(colors=c('gray',hue_pal()(3)[3]))
# 
# #barplot
# E16data<-cbind(E16prop,names(E16prop),rep('E16',length(names(E16prop))))
# P1data<-cbind(P1prop,names(P1prop),rep('P1',length(names(P1prop))))
# P5data<-cbind(P5prop,names(P5prop),rep('P5',length(names(P5prop))))
# data<-rbind(E16data,P1data,P5data)
# colnames(data)<-c('num','cluster','sample')
# data<-as.data.frame((data))
# data$num<-round(as.numeric(as.character(data$num)),2)
# 
# bar<-ggplot(data, aes(x=cluster, y=num, fill=sample)) +
#   geom_bar(stat="identity", position='dodge') +
#   ggtitle('Proportion of Sample in Cluster') + 
#   xlab('cluster')+
#   ylab('proportion')+
#   theme(axis.text.x = element_text(angle = 45, vjust = 1, hjust=1))
# 
# tt <- ttheme_default(colhead=list(fg_params = list(parse=TRUE)))
# 
# count<-table(integrated[['cluster_label']])[-grep("FailedClassification",names(table(integrated[['cluster_label']])))]
# count<-as.data.frame(count,row.names = T)
# colnames(count)<-'#cells'
# 
# tab<-tableGrob(count,theme = tt)
# plot_grid(bar,tab,rel_widths = c(0.8,0.2),scale=0.9)
# 
# 
# #Seek conserved markers between developmental stages
# Idents(E16)<-'cluster_label'
# E16Markers<-FindAllMarkers(E16,assay = 'RNA',logfc.threshold = log(1.5),only.pos=T)
# Idents(P1)<-'cluster_label'
# P1Markers<-FindAllMarkers(P1,assay = 'RNA',logfc.threshold = log(1.5),only.pos=T)
# Idents(P5)<-'cluster_label'
# P5Markers<-FindAllMarkers(P5,assay = 'RNA',logfc.threshold = log(1.5),only.pos=T)
# 
# conservedBetweenSampleMarkers<-data.frame()
# 
# for(cluster in unique(integrated[['cluster_label']][,1])){
#   E16genes<-E16Markers$gene[which(E16Markers$cluster==cluster)]
#   P1genes<-P1Markers$gene[which(P1Markers$cluster==cluster)]
#   P5genes<-P5Markers$gene[which(P5Markers$cluster==cluster)]
#   
#   conGenes<-intersect(intersect(E16genes,P1genes),P5genes)
#   conGenes<-cbind(conGenes,rep(cluster,length(conGenes)))
#   conservedBetweenSampleMarkers<-rbind(conservedBetweenSampleMarkers,conGenes)
# }
# 
# #if there aren't many, plot them all
# if(dim(conservedBetweenSampleMarkers)[1]<-50){
#   
#   
#   Input<-avg[['RNA']]@scale.data
#   
#   Input<-Input[conservedBetweenSampleMarkers$conGenes[order(conservedBetweenSampleMarkers$V2)],order(colnames(Input))]
#   
#   gplots::heatmap.2(as.matrix(Input),
#                     breaks = pairs.breaks,
#                     #symbreaks=F,
#                     keysize = 0.8,
#                     margins=c(8,8),
#                     key = T,
#                     main=NA,
#                     col = HeatCol,
#                     symkey = F,
#                     cexRow=0.5,
#                     cexCol = 1,
#                     Rowv= F,
#                     Colv =F,
#                     # ColSideColorsSize = 0.5,
#                     dendrogram = "none",
#                     scale = "none",
#                     #colsep = colsep,
#                     sepcolor = "black",
#                     labRow = rownames(Input),
#                     trace="none",
#                     density.info="none",
#                     srtCol=45,
#                     adjCol=c(1,1)
#                     #RowSideColors=c(rbind(cluster.cols,cluster.cols))
#   )
# }
# 
# 
