DEScoreClassify <- function(obj, DEGenes, markerList, className, specWeight=F, reannotate=F,  ...){
  
  celltypeList<-list()
  reannotation<-vector(length = length(unique(obj[[className]][,1])))
  names(reannotation)<-sort(unique(obj[[className]][,1]))
  celltype<-vector(length = length(unique(obj[[className]][,1])))
  names(celltype)<-sort(unique(obj[[className]][,1]))
  
  for(cluster in as.character(sort(unique(obj[[className]][,1])))){
    
    sub<-DEGenes[which(DEGenes$cluster==as.character(cluster)),]
    scocelltype<-vector(length=length(markerList))
    names(scocelltype)<- names(markerList)
    mList<-list()
    
    
    #Compute DEscore for each type
    for(type in names(scocelltype)){
      mark<-markerList[[type]]
      m<- sub[na.omit(match(mark,sub$gene)),]
      spec<-m$pct.1-m$pct.2
      spec<-sapply(spec,FUN=function(x) max(x,0))
      names(spec)<-m$gene
      
      if(rlang::is_empty(spec)){
        scocelltype[[type]]<-0
      }else{
        DEscore<- -log10(m$p_val_adj)
        
        if(specWeight){
          DEscore<-unlist(mapply(DEscore,FUN=function(x) min(x,20)))*spec
        }else{
          DEscore<-unlist(mapply(DEscore,FUN=function(x) min(x,20)))
        }
     
        scocelltype[type]<-sum(DEscore)
        mList[[type]]<-m
      }
      
      
    }
    
    celltypeList[[cluster]] <- list(mList, scocelltype)
    
    
    if(sum(scocelltype)==0){
      warning(paste0("No markers detected in DE genes for cluster: ", cluster))
      celltype[cluster]<-'Uncertain'
    }
    else if (length(grep(max(scocelltype), scocelltype))>1){
      #there are 2 or more classes with equal score. defer to class with highest log fold change?
      topMarkers<-mList[names(scocelltype)[grep(max(scocelltype), scocelltype)]]
      # totalScocelltype<-unlist(lapply(topMarkers,FUN=function(x) sum(-log10(x$p_val_adj))))
      # celltype[cluster]<- names(totalScocelltype)[grep(max(totalScocelltype),totalScocelltype)]
      
      sumLogFC <- unlist(lapply(topMarkers,FUN=function(x) sum(x$avg_logFC)))
      celltype[cluster]<- names(topMarkers) [grep(max(sumLogFC), sumLogFC)]
      
    } else{
      vals<-as.numeric(unlist(lapply(scocelltype,FUN=function(x)x[[1]])))
      names(vals)<-names(scocelltype)
      celltype[cluster]<-names(vals)[which(vals==max(vals))]
    }
    
    if(length(grep('Stressed', names(markerList))) > 0){
      if(scocelltype[['Stressed']][[1]]>10){
        celltype[cluster]<-'Stressed'
      }
    }
    
    
    if(reannotate){
      
      #which DE genes for this cluster
      m<-mList[[celltype[cluster]]]
      
      if(is.null(m)){
        #take the gene with highest logFC
        labelGene<-sub$gene[order(sub$avg_logFC,decreasing = T)][1]
      }else{
        #take the discovered marker with highest logFC
        labelGene<-m$gene[order(m$avg_logFC,decreasing = T)][1]
      }
      
      #has that identity already been found in another cluster?
      if(length(grep(labelGene,reannotation))>1){
        #get all the matching labels, seek maximum number on the end
        nams<-reannotation[grep( labelGene,reannotation)]
        nums<-lapply(nams,FUN=function(x) substring(x,nchar(x)))
        m<-max(as.numeric(nums))
        m<-m+1
        reannotation[cluster]<-paste0('Sst_', labelGene,'_',as.character(m))
        
      }
      else{
        reannotation[cluster]<-paste0('Sst_', labelGene,'_1')
      }
      
      
    }
    
    
  
    
  }
  
  names(celltypeList) <- sort(unique(obj[[className]][,1]))
  
  if(reannotate){
    out<-list(celltype, celltypeList, reannotation)
    names(out)<-c('celltype', 'scoreList', 'reannotation')
    return(out)
  }else{
    out<-list(celltype, celltypeList)
    names(out)<-c('celltype', 'scoreList')
    return(out)
  }

}
