

# This script uses iterative heirarchical clustering to group cells,
# checking at each stage for DEgenes to define groups as distinct

## ----receive input from nextflow----------------------------------------------
args <- commandArgs(TRUE)
path<-args[1]
file<-args[2]


print(path)
set.seed(123)
timepoints<-substr(file,12,nchar(file)-6)


## ---- Load standard package list ----------------------------------------------
source(paste0(path,'/bin/auxiliary/DirectoryChecker.R'))
source(paste0(path,'/bin/auxiliary/PackageLoader.R'))
source(paste0(path,'/bin/auxiliary/SetPlottingParameters.R'))

#Load functions that help us to go through nested lists
source(paste0(path,'/bin/auxiliary/NestedListsFunctions.R'))

#Load functions that specifically support this procedure: dendrogram handling, etc.
source(paste0(path,'/bin/auxiliary/DendrogramHandlerFunctions.R'))

#Load the function to perform iterative hierarchical clustering
source(paste0(path,'/bin/auxiliary/RecursiveClustering.R'))




#check ram
RAM<-get_ram()
print(paste(RAM,'RAM passed to Rscript'))

ncor=detectCores()
print(paste(ncor,'cores detected'))
plan("multiprocess", workers = ncor -1)
options(future.globals.minSize = 10000 * 1024^2)




## ---- File setup ----------------------------------------------

#load data files
load(file)


#integrated_clean<-subset(integrated,cells=sample(1:8807,4000,replace = F))
integrated_clean<-subset(integrated,cells=WhichCells(integrated,expression=putative_identity!='Meis2'))
print('starting recursive classification')




## ---- Clustering ----------------------------------------------

#Original setting below
dendrogram<-RecursiveClustering(integrated_clean,minSize = 50,DEscore.thresh = 60)
print('Clustering Complete')


#pass to next process
save(dendrogram,file='clustering_dend.Rdata')





