# This code is part of Qiskit.
#
# (C) Copyright IBM 2019.
#
# This code is licensed under the Apache License, Version 2.0. You may
# obtain a copy of this license in the LICENSE.txt file in the root directory
# of this source tree or at http://www.apache.org/licenses/LICENSE-2.0.
#
# Any modifications or derivative works of this code must retain this
# copyright notice, and modified files need to carry a notice indicating
# that they have been altered from the originals.


"""
Mocked versions of real quantum backends.
"""

# BackendV2 Backends
from .almaden import FakeAlmadenV2
from .armonk import FakeArmonkV2
from .athens import FakeAthensV2
from .auckland import FakeAuckland
from .belem import FakeBelemV2
from .boeblingen import FakeBoeblingenV2
from .bogota import FakeBogotaV2
from .brooklyn import FakeBrooklynV2
from .burlington import FakeBurlingtonV2
from .cairo import FakeCairoV2
from .cambridge import FakeCambridgeV2
from .casablanca import FakeCasablancaV2
from .essex import FakeEssexV2
from .geneva import FakeGeneva
from .guadalupe import FakeGuadalupeV2
from .hanoi import FakeHanoiV2
from .jakarta import FakeJakartaV2
from .johannesburg import FakeJohannesburgV2
from .kolkata import FakeKolkataV2
from .lagos import FakeLagosV2
from .lima import FakeLimaV2
from .london import FakeLondonV2
from .manhattan import FakeManhattanV2
from .manila import FakeManilaV2
from .melbourne import FakeMelbourneV2
from .montreal import FakeMontrealV2
from .mumbai import FakeMumbaiV2
from .nairobi import FakeNairobiV2
from .oslo import FakeOslo
from .ourense import FakeOurenseV2
from .paris import FakeParisV2
from .perth import FakePerth
from .prague import FakePrague
from .poughkeepsie import FakePoughkeepsieV2
from .quito import FakeQuitoV2
from .rochester import FakeRochesterV2
from .rome import FakeRomeV2
from .santiago import FakeSantiagoV2
from .sherbrooke import FakeSherbrooke
from .singapore import FakeSingaporeV2
from .sydney import FakeSydneyV2
from .toronto import FakeTorontoV2
from .valencia import FakeValenciaV2
from .vigo import FakeVigoV2
from .washington import FakeWashingtonV2
from .yorktown import FakeYorktownV2

# BackendV1 Backends
from .almaden import FakeAlmaden
from .armonk import FakeArmonk
from .athens import FakeAthens
from .belem import FakeBelem
from .boeblingen import FakeBoeblingen
from .bogota import FakeBogota
from .brooklyn import FakeBrooklyn
from .burlington import FakeBurlington
from .cairo import FakeCairo
from .cambridge import FakeCambridge
from .cambridge import FakeCambridgeAlternativeBasis
from .casablanca import FakeCasablanca
from .essex import FakeEssex
from .guadalupe import FakeGuadalupe
from .hanoi import FakeHanoi
from .jakarta import FakeJakarta
from .johannesburg import FakeJohannesburg
from .kolkata import FakeKolkata
from .lagos import FakeLagos
from .lima import FakeLima
from .london import FakeLondon
from .manhattan import FakeManhattan
from .manila import FakeManila
from .melbourne import FakeMelbourne
from .montreal import FakeMontreal
from .mumbai import FakeMumbai
from .nairobi import FakeNairobi
from .ourense import FakeOurense
from .paris import FakeParis
from .poughkeepsie import FakePoughkeepsie
from .quito import FakeQuito
from .rochester import FakeRochester
from .rome import FakeRome
from .rueschlikon import FakeRueschlikon
from .santiago import FakeSantiago
from .singapore import FakeSingapore
from .sydney import FakeSydney
from .tenerife import FakeTenerife
from .tokyo import FakeTokyo
from .toronto import FakeToronto
from .valencia import FakeValencia
from .vigo import FakeVigo
from .washington import FakeWashington
from .yorktown import FakeYorktown
