% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors.R
\name{friendly_pal}
\alias{friendly_pal}
\title{A color blind friendly color palette generator}
\usage{
friendly_pal(name, n, type = c("discrete", "continuous"))
}
\arguments{
\item{name}{Name of desired palette. Choices are:
\code{bright_seven}, \code{contrast_three},  \code{vibrant_seven},
\code{muted_nine}, \code{nickel_five},  \code{ito_eight}}

\item{n}{Number of colors desired.}

\item{type}{Either "continuous" or "discrete". Use continuous if you want
to automatically interpolate between colours.
@importFrom graphics rgb rect par image text}
}
\value{
A vector of colours.
}
\description{
Code is based on the wes anderson package https://github.com/karthik/wesanderson
These are a handful of color palettes that are color blind friendly.
}
\examples{
friendly_pal("bright_seven")
friendly_pal("contrast_three")
friendly_pal("vibrant_seven")
friendly_pal("vibrant_seven", 3)

# If you need more colours than normally found in a palette, you
# can use a continuous palette to interpolate between existing
# colours
pal <- friendly_pal(21, name = "muted_nine", type = "continuous")
image(volcano, col = pal)
}
\keyword{colors}
